/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transport.jettyrest.http;

import java.io.IOException;
import java.io.Writer;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.transport.jettyrest.http.JettyMonitor;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyTransport {
    private static final String ANNOUNCE = "org.eclipse.jetty.util.log.announce";
    private static final String LOG_CLASS = "org.eclipse.jetty.util.log.class";
    private final KeyStore keyStore;
    private final boolean useHttps;
    private final Monitor monitor;
    private int httpPort = 8080;
    private Server server;
    private List<Handler> handlers = new ArrayList<Handler>();

    public JettyTransport(KeyStore keyStore, boolean useHttps, Monitor monitor) {
        this.keyStore = keyStore;
        this.useHttps = useHttps;
        this.monitor = monitor;
        System.setProperty(LOG_CLASS, JettyMonitor.class.getName());
        System.setProperty(ANNOUNCE, "false");
        monitor.info(() -> "Creating JettyTransport. useHttps=" + useHttps, new Object[0]);
    }

    public void start() {
        try {
            if (this.useHttps) {
                this.server = new Server();
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStore(this.keyStore);
                sslContextFactory.setKeyStorePassword("password");
                sslContextFactory.setKeyManagerPassword("password");
                HttpConfiguration https = new HttpConfiguration();
                ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
                sslConnector.setPort(this.httpPort);
                this.server.setConnectors(new Connector[]{sslConnector});
            } else {
                this.server = new Server(this.httpPort);
                ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
                connector.setPort(this.httpPort);
                this.server.setConnectors(new Connector[]{connector});
            }
            this.server.setErrorHandler((ErrorHandler)new JettyErrorHandler());
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[0]));
            this.server.setHandler((Handler)contexts);
            this.server.start();
            this.monitor.info(() -> "Using Jetty transport", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting Jetty transport", e);
        }
    }

    public void shutdown() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Error stopping Jetty transport", e);
        }
    }

    public void registerServlet(String path, Servlet servletContainer) {
        ServletHolder servletHolder = new ServletHolder(Source.EMBEDDED);
        servletHolder.setName("Data Transfer Project");
        servletHolder.setServlet(servletContainer);
        servletHolder.setInitOrder(1);
        ServletContextHandler handler = new ServletContextHandler(0);
        handler.setContextPath("/");
        this.handlers.add((Handler)handler);
        handler.getServletHandler().addServletWithMapping(servletHolder, path);
    }

    private class JettyErrorHandler
    extends ErrorHandler {
        private JettyErrorHandler() {
        }

        protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
            writer.write("{ error: '" + code + "'}");
        }
    }
}

