/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transport.jettyrest;

import java.security.KeyStore;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.api.transport.TransportBinder;
import org.datatransferproject.spi.service.extension.ServiceExtension;
import org.datatransferproject.transport.jettyrest.http.JettyMonitor;
import org.datatransferproject.transport.jettyrest.http.JettyTransport;
import org.datatransferproject.transport.jettyrest.rest.JerseyTransportBinder;

public class JettyRestExtension
implements ServiceExtension {
    private JettyTransport transport;
    private JerseyTransportBinder binder;

    public void initialize(ExtensionContext context) {
        Monitor monitor = context.getMonitor();
        JettyMonitor.setDelegate(monitor);
        KeyStore keyStore = (KeyStore)context.getService(KeyStore.class);
        boolean useHttps = (Boolean)context.getSetting("useHttps", (Object)true);
        this.transport = new JettyTransport(keyStore, useHttps, monitor);
        this.binder = new JerseyTransportBinder(this.transport);
        context.registerService(TransportBinder.class, (Object)this.binder);
    }

    public void start() {
        this.binder.start();
        this.transport.start();
    }

    public void shutdown() {
        this.transport.shutdown();
    }
}

