/**
 * Copyright 2011-2012 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dbist.admin;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Steve M. Jung
 * @since 2012. 2. 18. (version 1.0.0)
 */
public class ParameterUtils {

	public static String get(HttpServletRequest request, String name) {
		String sessionAttrName = request.getServletPath() + "." + name;
		String value = null;
		try {
			value = request.getParameter(name);
			if (value != null)
				return value;
			value = (String) request.getAttribute(name);
			if (value != null)
				return value;
		} finally {
			if (value != null)
				request.getSession().setAttribute(sessionAttrName, value);
		}
		return (String) request.getSession().getAttribute(sessionAttrName);
	}

	public static String[] getValues(HttpServletRequest request, String name) {
		String sessionAttrName = request.getServletPath() + "." + name;
		String[] value = null;
		try {
			value = request.getParameterValues(name);
			if (value != null)
				return value;
			value = (String[]) request.getAttribute(name);
			if (value != null)
				return value;
		} finally {
			if (value != null)
				request.getSession().setAttribute(sessionAttrName, value);
		}
		return (String[]) request.getSession().getAttribute(sessionAttrName);
	}

}
