/*
 * Decompiled with CFR 0.152.
 */
package org.dblock.log4jna.nt;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Win32EventLog", category="Core", elementType="appender", printObject=true)
public class Win32EventLogAppender
extends AbstractAppender {
    private static final String EVENT_LOG_PATH = "SYSTEM\\CurrentControlSet\\Services\\EventLog\\";
    private static final String CATEGORY_MESSAGE_FILE = "CategoryMessageFile";
    private static final String EVENT_MESSAGE_FILE = "EventMessageFile";
    private static final int CATEGORY_COUNT = 6;
    private static final int TYPES_SUPPORTED = 7;
    private static final String DEFAULT_SOURCE = "Log4jna";
    private static final String DEFAULT_APPLICATION = "Application";
    private String _source = null;
    private String _server = null;
    private String _application = "Application";
    private String _eventMessageFile = "";
    private String _categoryMessageFile = "";
    private WinNT.HANDLE _handle = null;

    @PluginFactory
    public static Win32EventLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="server") String server, @PluginAttribute(value="source") String source, @PluginAttribute(value="application") String application, @PluginAttribute(value="eventMessageFile") String eventMessageFile, @PluginAttribute(value="categoryMessageFile") String categoryMessageFile, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter) {
        return new Win32EventLogAppender(name, server, source, application, eventMessageFile, categoryMessageFile, layout, filter);
    }

    public Win32EventLogAppender(String name, String server, String source, String application, String eventMessageFile, String categoryMessageFile, Layout<? extends Serializable> layout, Filter filter) {
        super(name, filter, layout);
        Path p;
        if (source == null || source.length() == 0) {
            source = DEFAULT_SOURCE;
        }
        if (eventMessageFile != null && Files.exists(p = Paths.get(eventMessageFile, new String[0]), new LinkOption[0])) {
            this.setEventMessageFile(p.toAbsolutePath().toString());
        }
        if (categoryMessageFile != null && Files.exists(p = Paths.get(categoryMessageFile, new String[0]), new LinkOption[0])) {
            this.setCategoryMessageFile(p.toAbsolutePath().toString());
        }
        this._server = server;
        this.setSource(source);
        this.setApplication(application);
    }

    public void setSource(String source) {
        if (source == null || source.length() == 0) {
            source = DEFAULT_SOURCE;
        }
        this._source = source.trim();
    }

    public String getSource() {
        return this._source;
    }

    public void setApplication(String application) {
        if (application == null || application.length() == 0) {
            application = DEFAULT_APPLICATION;
        }
        this._application = application.trim();
    }

    public String getApplication() {
        return this._application;
    }

    public void close() {
        if (this._handle != null) {
            if (!Advapi32.INSTANCE.DeregisterEventSource(this._handle)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this._handle = null;
        }
    }

    public void setEventMessageFile(String eventMessageFile) {
        this._eventMessageFile = eventMessageFile.trim();
    }

    public String getEventMessageFile() {
        return this._eventMessageFile;
    }

    public void setCategoryMessageFile(String categoryMessageFile) {
        this._categoryMessageFile = categoryMessageFile.trim();
    }

    public String getCategoryMessageFile() {
        return this._categoryMessageFile;
    }

    private void registerEventSource() {
        this.close();
        try {
            this._handle = this.registerEventSource(this._server, this._source, this._application, this._eventMessageFile, this._categoryMessageFile);
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException("Could not register event source.", e);
        }
    }

    public void activateOptions() {
        this.registerEventSource();
    }

    @Override
    public void append(LogEvent event) {
        if (this._handle == null) {
            this.registerEventSource();
        }
        String s = new String(this.getLayout().toByteArray(event));
        int messageID = 4096;
        String[] buffer = new String[]{s};
        if (!Advapi32.INSTANCE.ReportEvent(this._handle, Win32EventLogAppender.getEventLogType(event.getLevel()), Win32EventLogAppender.getEventLogCategory(event.getLevel()), 4096, null, buffer.length, 0, buffer, null)) {
            Win32Exception e = new Win32Exception(Kernel32.INSTANCE.GetLastError());
            this.getHandler().error("Failed to report event [" + s + "].", event, e);
        }
    }

    public void finalize() {
        this.close();
    }

    public boolean requiresLayout() {
        return true;
    }

    private WinNT.HANDLE registerEventSource(String server, String source, String application, String eventMessageFile, String categoryMessageFile) {
        String applicationKeyPath = EVENT_LOG_PATH + application;
        String eventSourceKeyPath = applicationKeyPath + "\\" + source;
        if (Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, applicationKeyPath)) {
            if (Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath)) {
                this.setVariableKeys(eventMessageFile, categoryMessageFile, eventSourceKeyPath);
            } else {
                this.createAndSetAllKeys(eventMessageFile, categoryMessageFile, eventSourceKeyPath);
            }
        } else {
            this.createAndSetAllKeys(eventMessageFile, categoryMessageFile, eventSourceKeyPath);
        }
        WinNT.HANDLE h = Advapi32.INSTANCE.RegisterEventSource(server, source);
        if (h == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return h;
    }

    private void createAndSetAllKeys(String eventMessageFile, String categoryMessageFile, String eventSourceKeyPath) {
        if (Advapi32Util.registryCreateKey(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath)) {
            Advapi32Util.registrySetIntValue(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, "TypesSupported", 7);
            Advapi32Util.registrySetIntValue(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, "CategoryCount", 6);
            this.setVariableKeys(eventMessageFile, categoryMessageFile, eventSourceKeyPath);
        }
    }

    private void setVariableKeys(String eventMessageFile, String categoryMessageFile, String eventSourceKeyPath) {
        if (!Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, EVENT_MESSAGE_FILE) || !Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, EVENT_MESSAGE_FILE).equalsIgnoreCase(eventMessageFile)) {
            Advapi32Util.registrySetStringValue(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, EVENT_MESSAGE_FILE, eventMessageFile);
        }
        if (!Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, CATEGORY_MESSAGE_FILE) || !Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, CATEGORY_MESSAGE_FILE).equalsIgnoreCase(categoryMessageFile)) {
            Advapi32Util.registrySetStringValue(WinReg.HKEY_LOCAL_MACHINE, eventSourceKeyPath, CATEGORY_MESSAGE_FILE, categoryMessageFile);
        }
    }

    private static int getEventLogType(Level level) {
        int type = 0;
        if (level.intLevel() <= Level.INFO.intLevel()) {
            type = 4;
            if (level.intLevel() <= Level.WARN.intLevel()) {
                type = 2;
                if (level.intLevel() <= Level.ERROR.intLevel()) {
                    type = 1;
                }
            }
        }
        return type;
    }

    private static int getEventLogCategory(Level level) {
        int category = 1;
        if (level.intLevel() >= Level.DEBUG.intLevel()) {
            category = 2;
            if (level.intLevel() >= Level.INFO.intLevel()) {
                category = 3;
                if (level.intLevel() >= Level.WARN.intLevel()) {
                    category = 4;
                    if (level.intLevel() >= Level.ERROR.intLevel()) {
                        category = 5;
                        if (level.intLevel() >= Level.FATAL.intLevel()) {
                            category = 6;
                        }
                    }
                }
            }
        }
        return category;
    }
}

