/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.databus;

import com.rometools.rome.feed.synd.SyndCategoryImpl;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dbpedia.databus.BaseEntity;
import org.dbpedia.databus.Locations;
import org.dbpedia.databus.Parameters;
import org.dbpedia.databus.Properties;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001%\u0011\u0011\"\u00169eCR,'k]:\u000b\u0005\r!\u0011a\u00023bi\u0006\u0014Wo\u001d\u0006\u0003\u000b\u0019\tq\u0001\u001a2qK\u0012L\u0017MC\u0001\b\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0002\u0006\t\u0003\u0017Ii\u0011\u0001\u0004\u0006\u0003\u001b9\ta\u0001\u001d7vO&t'BA\b\u0011\u0003\u0015i\u0017M^3o\u0015\t\tb!\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003'1\u0011A\"\u00112tiJ\f7\r^'pU>\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\b;\u0001\u0011\r\u0011\"\u0001\u001f\u0003!1W-\u001a3UsB,W#A\u0010\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001\u00027b]\u001eT\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\t11\u000b\u001e:j]\u001eDa\u0001\u000b\u0001!\u0002\u0013y\u0012!\u00034fK\u0012$\u0016\u0010]3!\u0011\u0015Q\u0003\u0001\"\u0011,\u0003\u001d)\u00070Z2vi\u0016$\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000fK\u0002*ge\u00022!\f\u001b7\u0013\t)dF\u0001\u0004uQJ|wo\u001d\t\u0003\u0017]J!\u0001\u000f\u0007\u0003-5{'n\\#yK\u000e,H/[8o\u000bb\u001cW\r\u001d;j_:\fDA\b\u001eE;B\u00111H\u0011\b\u0003y\u0001\u0003\"!\u0010\u0018\u000e\u0003yR!a\u0010\u0005\u0002\rq\u0012xn\u001c;?\u0013\t\te&\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\rS!!\u0011\u00182\u000b\r*\u0015\n\u0017&\u0016\u0005\u0019;U#\u0001\u001e\u0005\u000b!C!\u0019A'\u0003\u0003QK!AS&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\tae&\u0001\u0004uQJ|wo]\t\u0003\u001dF\u0003\"!L(\n\u0005As#a\u0002(pi\"Lgn\u001a\t\u0003%Vs!!L*\n\u0005Qs\u0013a\u00029bG.\fw-Z\u0005\u0003-^\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005Qs\u0013'B\u0012Z5nceBA\u0017[\u0013\tae&\r\u0003#[9b&!B:dC2\f\u0017G\u0001\u00147\u0011\u0015y\u0006\u0001\"\u0001a\u0003E1'o\\7GK\u0016$G)\u001b:fGR|'/\u001f\u000b\u0002CB\u0011!-\\\u0007\u0002G*\u0011A-Z\u0001\u0005gftGM\u0003\u0002gO\u0006!a-Z3e\u0015\tA\u0017.\u0001\u0003s_6,'B\u00016l\u0003%\u0011x.\\3u_>d7OC\u0001m\u0003\r\u0019w.\\\u0005\u0003]\u000e\u0014\u0001bU=oI\u001a+W\r\u001a\u0015\u0007\u0001AD\u0018p\u001f?\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018aC1o]>$\u0018\r^5p]NT!!\u001e\b\u0002\u000fAdWoZ5og&\u0011qO\u001d\u0002\u0005\u001b>Tw.\u0001\u0003oC6,\u0017%\u0001>\u0002\u0015U\u0004H-\u0019;f[I\u001c8/\u0001\u0007eK\u001a\fW\u000f\u001c;QQ\u0006\u001cX\rJ\u0001~\u0013\tqx0A\bQ%\u0016\u0003\u0016IU#`!\u0006\u001b5*Q$F\u0015\r\t\tA]\u0001\u000f\u0019&4WmY=dY\u0016\u0004\u0006.Y:f\u0001")
@Mojo(name="update-rss", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class UpdateRss
extends AbstractMojo
implements Properties {
    private final String feedType;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private final String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private final String version;
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    private final String packaging;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private final File mavenTargetDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private final String finalName;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}", readonly=true)
    private final String multiModuleBaseDirectory;
    @Parameter
    private final File dataInputDirectory;
    @Parameter
    private final File packageDirectory;
    @Parameter
    private final File dataDependencyDirectory;
    @Parameter
    private final File pluginDirectory;
    @Parameter
    private final boolean includeParseLogs;
    @Parameter
    private final String bundle;
    @Parameter
    private final URL downloadUrlPath;
    @Parameter
    private final boolean allowOverwriteOnDeploy;
    @Parameter(property="databus.deployToTestRepo")
    private final boolean deployToTestRepo;
    @Parameter
    private final String feedFrom;
    @Parameter(property="databus.skipHashing")
    private final boolean skipHashing;
    @Parameter
    private final File pkcs12File;
    @Parameter
    private final URL maintainer;
    @Parameter
    private final URL publisher;
    @Parameter
    private final String license;
    @Parameter
    private final String downloadURL;
    @Parameter
    private final String issuedDate;
    @Parameter
    private final String modifiedDate;
    @Parameter
    private final java.util.List<String> labels;
    @Parameter
    private final String datasetDescription;
    @Parameter
    private final java.util.List<BaseEntity> wasDerivedFrom;
    private final LocalDateTime invocationTime;
    private Parameters.Parameters params;
    private Locations.Locations locations;
    private volatile byte bitmap$0;

    @Override
    public boolean isParent() {
        return Properties.isParent$(this);
    }

    @Override
    public File getDataIdFile() {
        return Properties.getDataIdFile$(this);
    }

    @Override
    public better.files.File dataIdFile() {
        return Properties.dataIdFile$(this);
    }

    @Override
    public better.files.File dataIdPackageTarget() {
        return Properties.dataIdPackageTarget$(this);
    }

    @Override
    public String dataIdDownloadLocation() {
        return Properties.dataIdDownloadLocation$(this);
    }

    @Override
    public File getParseLogFile() {
        return Properties.getParseLogFile$(this);
    }

    @Override
    public File getFeedFile() {
        return Properties.getFeedFile$(this);
    }

    @Override
    public File getDataIdDirectory() {
        return Properties.getDataIdDirectory$(this);
    }

    @Override
    public File getParselogDirectory() {
        return Properties.getParselogDirectory$(this);
    }

    @Override
    public File getFeedDirectory() {
        return Properties.getFeedDirectory$(this);
    }

    @Override
    public File getPackageDirectory() {
        return Properties.getPackageDirectory$(this);
    }

    @Override
    public better.files.File packageSubdirectory() {
        return Properties.packageSubdirectory$(this);
    }

    @Override
    public File getDatafileFinal(File datafile) {
        return Properties.getDatafileFinal$(this, datafile);
    }

    @Override
    public File getDatafilePackageTarget(File datafile) {
        return Properties.getDatafilePackageTarget$(this, datafile);
    }

    @Override
    public List<File> getListOfDataFiles() {
        return Properties.getListOfDataFiles$(this);
    }

    @Override
    public String artifactId() {
        return this.artifactId;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String packaging() {
        return this.packaging;
    }

    @Override
    public File mavenTargetDirectory() {
        return this.mavenTargetDirectory;
    }

    @Override
    public String finalName() {
        return this.finalName;
    }

    @Override
    public String multiModuleBaseDirectory() {
        return this.multiModuleBaseDirectory;
    }

    @Override
    public File dataInputDirectory() {
        return this.dataInputDirectory;
    }

    @Override
    public File packageDirectory() {
        return this.packageDirectory;
    }

    @Override
    public File dataDependencyDirectory() {
        return this.dataDependencyDirectory;
    }

    @Override
    public File pluginDirectory() {
        return this.pluginDirectory;
    }

    @Override
    public boolean includeParseLogs() {
        return this.includeParseLogs;
    }

    @Override
    public String bundle() {
        return this.bundle;
    }

    @Override
    public URL downloadUrlPath() {
        return this.downloadUrlPath;
    }

    @Override
    public boolean allowOverwriteOnDeploy() {
        return this.allowOverwriteOnDeploy;
    }

    @Override
    public boolean deployToTestRepo() {
        return this.deployToTestRepo;
    }

    @Override
    public String feedFrom() {
        return this.feedFrom;
    }

    @Override
    public boolean skipHashing() {
        return this.skipHashing;
    }

    @Override
    public File pkcs12File() {
        return this.pkcs12File;
    }

    @Override
    public URL maintainer() {
        return this.maintainer;
    }

    @Override
    public URL publisher() {
        return this.publisher;
    }

    @Override
    public String license() {
        return this.license;
    }

    @Override
    public String downloadURL() {
        return this.downloadURL;
    }

    @Override
    public String issuedDate() {
        return this.issuedDate;
    }

    @Override
    public String modifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public java.util.List<String> labels() {
        return this.labels;
    }

    @Override
    public String datasetDescription() {
        return this.datasetDescription;
    }

    @Override
    public java.util.List<BaseEntity> wasDerivedFrom() {
        return this.wasDerivedFrom;
    }

    @Override
    public LocalDateTime invocationTime() {
        return this.invocationTime;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$artifactId_$eq(String x$1) {
        this.artifactId = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$version_$eq(String x$1) {
        this.version = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$packaging_$eq(String x$1) {
        this.packaging = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$mavenTargetDirectory_$eq(File x$1) {
        this.mavenTargetDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$finalName_$eq(String x$1) {
        this.finalName = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$multiModuleBaseDirectory_$eq(String x$1) {
        this.multiModuleBaseDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$dataInputDirectory_$eq(File x$1) {
        this.dataInputDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$packageDirectory_$eq(File x$1) {
        this.packageDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$dataDependencyDirectory_$eq(File x$1) {
        this.dataDependencyDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$pluginDirectory_$eq(File x$1) {
        this.pluginDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$includeParseLogs_$eq(boolean x$1) {
        this.includeParseLogs = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$bundle_$eq(String x$1) {
        this.bundle = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$downloadUrlPath_$eq(URL x$1) {
        this.downloadUrlPath = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$allowOverwriteOnDeploy_$eq(boolean x$1) {
        this.allowOverwriteOnDeploy = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$deployToTestRepo_$eq(boolean x$1) {
        this.deployToTestRepo = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$feedFrom_$eq(String x$1) {
        this.feedFrom = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$skipHashing_$eq(boolean x$1) {
        this.skipHashing = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$pkcs12File_$eq(File x$1) {
        this.pkcs12File = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$maintainer_$eq(URL x$1) {
        this.maintainer = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$publisher_$eq(URL x$1) {
        this.publisher = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$license_$eq(String x$1) {
        this.license = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$downloadURL_$eq(String x$1) {
        this.downloadURL = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$issuedDate_$eq(String x$1) {
        this.issuedDate = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$modifiedDate_$eq(String x$1) {
        this.modifiedDate = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$labels_$eq(java.util.List<String> x$1) {
        this.labels = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$datasetDescription_$eq(String x$1) {
        this.datasetDescription = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$wasDerivedFrom_$eq(java.util.List<BaseEntity> x$1) {
        this.wasDerivedFrom = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$invocationTime_$eq(LocalDateTime x$1) {
        this.invocationTime = x$1;
    }

    private Parameters.Parameters params$lzycompute() {
        UpdateRss updateRss = this;
        synchronized (updateRss) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.params = Parameters.params$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.params;
    }

    @Override
    public Parameters.Parameters params() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.params$lzycompute() : this.params;
    }

    private Locations.Locations locations$lzycompute() {
        UpdateRss updateRss = this;
        synchronized (updateRss) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.locations = Locations.locations$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.locations;
    }

    @Override
    public Locations.Locations locations() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.locations$lzycompute() : this.locations;
    }

    public String feedType() {
        return this.feedType;
    }

    public void execute() throws MojoExecutionException {
        Boolean bl;
        if (this.isParent()) {
            this.getLog().info((CharSequence)"skipping parent module");
            return;
        }
        SyndFeedInput input = new SyndFeedInput();
        SyndFeedImpl newFeed = new SyndFeedImpl();
        SyndFeed oldFeed = null;
        if (this.feedFrom().contentEquals("")) {
            oldFeed = this.fromFeedDirectory();
        } else if (this.feedFrom().startsWith("http://")) {
            try {
                oldFeed = input.build((Reader)new InputStreamReader(new URL(this.feedFrom()).openStream()));
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)"old feed not found");
                oldFeed = this.fromFeedDirectory();
            }
        } else {
            try {
                oldFeed = input.build(new File(this.feedFrom()));
            }
            catch (FileNotFoundException fne) {
                this.getLog().info((CharSequence)"old feed not found");
                oldFeed = this.fromFeedDirectory();
            }
        }
        SyndEntryImpl entry = new SyndEntryImpl();
        ObjectRef title = ObjectRef.create((Object)this.finalName());
        entry.setTitle(this.finalName());
        Path dataidPath = Paths.get(this.getDataIdFile().toString(), new String[0]);
        Path feedPath = Paths.get(this.getFeedDirectory().toString(), new String[0]);
        Path relative = feedPath.relativize(dataidPath);
        entry.setLink(((Object)relative).toString());
        entry.setPublishedDate(new SimpleDateFormat("yyyy-MM-dd").parse(this.modifiedDate()));
        SyndContentImpl description = new SyndContentImpl();
        description.setType("text/plain");
        description.setValue("TODO data from changelog");
        entry.setDescription((SyndContent)description);
        if (oldFeed != null) {
            Boolean bl2;
            newFeed = oldFeed;
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(oldFeed.getEntries()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UpdateRss.$anonfun$execute$1(title, x$1)));
            if (option instanceof Some) {
                this.getLog().info((CharSequence)new StringBuilder(16).append((String)title.elem).append(" already in feed").toString());
                bl2 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)newFeed.getEntries().add(entry));
            } else {
                throw new MatchError((Object)option);
            }
            bl = bl2;
        } else {
            newFeed.setTitle(this.artifactId());
            newFeed.setFeedType(this.feedType());
            newFeed.setAuthor(this.maintainer().toString());
            newFeed.setDescription(this.datasetDescription());
            newFeed.setCopyright("Copyright TODO");
            newFeed.setLink("path/to/dataid_catalog.ttl");
            ArrayList<SyndCategoryImpl> categories = new ArrayList<SyndCategoryImpl>();
            SyndCategoryImpl cat = new SyndCategoryImpl();
            cat.setName("Databus and TODO");
            categories.add(cat);
            newFeed.setCategories(categories);
            java.util.List entries = newFeed.getEntries();
            entries.add(entry);
            newFeed.setEntries(entries);
            bl = BoxedUnit.UNIT;
        }
        SyndFeedOutput output = new SyndFeedOutput();
        StringWriter tmpFeed = new StringWriter();
        output.output((SyndFeed)newFeed, (Writer)tmpFeed);
        newFeed = input.build((Reader)new StringReader(((Object)tmpFeed).toString()));
        output.output((SyndFeed)newFeed, (Writer)new FileWriter(this.getFeedFile()));
    }

    public SyndFeed fromFeedDirectory() {
        SyndFeedInput input = new SyndFeedInput();
        File oldReleaseFeedFile = this.getFeedFile();
        if (oldReleaseFeedFile.exists()) {
            return input.build(oldReleaseFeedFile);
        }
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(ObjectRef title$1, SyndEntry x$1) {
        return x$1.getTitle().contentEquals((String)title$1.elem);
    }

    public UpdateRss() {
        Locations.$init$(this);
        Parameters.$init$(this);
        Properties.$init$(this);
        this.feedType = "rss_1.0";
    }
}

