/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.databus;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.net.URL;
import java.time.LocalDateTime;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dbpedia.databus.BaseEntity;
import org.dbpedia.databus.Locations;
import org.dbpedia.databus.Parameters;
import org.dbpedia.databus.Properties;
import org.dbpedia.databus.SigningHelpers;
import org.dbpedia.databus.shared.authentification.PKCS12File;
import org.dbpedia.databus.shared.authentification.RSAKeyPair;
import org.dbpedia.databus.shared.authentification.RSAModulusAndExponent;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u0013\tAa+\u00197jI\u0006$XM\u0003\u0002\u0004\t\u00059A-\u0019;bEV\u001c(BA\u0003\u0007\u0003\u001d!'\r]3eS\u0006T\u0011aB\u0001\u0004_J<7\u0001A\n\u0006\u0001)!\u0002d\u0007\t\u0003\u0017Ii\u0011\u0001\u0004\u0006\u0003\u001b9\ta\u0001\u001d7vO&t'BA\b\u0011\u0003\u0015i\u0017M^3o\u0015\t\tb!\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003'1\u0011A\"\u00112tiJ\f7\r^'pU>\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0005\u0002\u00163%\u0011!D\u0001\u0002\u000f'&<g.\u001b8h\u0011\u0016d\u0007/\u001a:t!\ta2%D\u0001\u001e\u0015\tqr$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002!C\u0005AA/\u001f9fg\u00064WMC\u0001#\u0003\r\u0019w.\\\u0005\u0003Iu\u00111\u0002T1{s2{wmZ5oO\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003+\u0001AQA\u000b\u0001\u0005B-\nq!\u001a=fGV$X\rF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\u0007%\u001a\u0014\bE\u0002.iYJ!!\u000e\u0018\u0003\rQD'o\\<t!\tYq'\u0003\u00029\u0019\t1Rj\u001c6p\u000bb,7-\u001e;j_:,\u0005pY3qi&|g.\r\u0003\u001fu\u0015s\u0006CA\u001eC\u001d\ta\u0004\t\u0005\u0002>]5\taH\u0003\u0002@\u0011\u00051AH]8pizJ!!\u0011\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003:\nTa\t$K3.+\"a\u0012%\u0016\u0003i\"Q!\u0013\u0005C\u00029\u0013\u0011\u0001V\u0005\u0003\u00172\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$BA'/\u0003\u0019!\bN]8xgF\u0011qJ\u0015\t\u0003[AK!!\u0015\u0018\u0003\u000f9{G\u000f[5oOB\u00111K\u0016\b\u0003[QK!!\u0016\u0018\u0002\u000fA\f7m[1hK&\u0011q\u000b\u0017\u0002\n)\"\u0014xn^1cY\u0016T!!\u0016\u00182\u000b\rR6\fX'\u000f\u00055Z\u0016BA'/c\u0011\u0011SFL/\u0003\u000bM\u001c\u0017\r\\12\u0005\u00192\u0004\"\u00021\u0001\t\u0003Y\u0013!\u0004<bY&$\u0017\r^3XK\nLE\r\u000b\u0004\u0001E*\\WN\u001c\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f1\"\u00198o_R\fG/[8og*\u0011qMD\u0001\ba2,x-\u001b8t\u0013\tIGM\u0001\u0003N_*|\u0017\u0001\u00028b[\u0016\f\u0013\u0001\\\u0001\tm\u0006d\u0017\u000eZ1uK\u0006aA-\u001a4bk2$\b\u000b[1tK\u0012\nq.\u0003\u0002qc\u0006Aa+\u0011'J\t\u0006#VI\u0003\u0002sI\u0006qA*\u001b4fGf\u001cG.\u001a)iCN,\u0007")
@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE)
public class Validate
extends AbstractMojo
implements Properties,
SigningHelpers,
LazyLogging {
    private transient Logger logger;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private final String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private final String version;
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    private final String packaging;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private final File mavenTargetDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private final String finalName;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}", readonly=true)
    private final String multiModuleBaseDirectory;
    @Parameter
    private final File dataInputDirectory;
    @Parameter
    private final File packageDirectory;
    @Parameter
    private final File dataDependencyDirectory;
    @Parameter
    private final File pluginDirectory;
    @Parameter
    private final boolean includeParseLogs;
    @Parameter
    private final String bundle;
    @Parameter
    private final URL downloadUrlPath;
    @Parameter
    private final boolean allowOverwriteOnDeploy;
    @Parameter(property="databus.deployToTestRepo")
    private final boolean deployToTestRepo;
    @Parameter
    private final String feedFrom;
    @Parameter(property="databus.skipHashing")
    private final boolean skipHashing;
    @Parameter
    private final File pkcs12File;
    @Parameter
    private final URL maintainer;
    @Parameter
    private final URL publisher;
    @Parameter
    private final String license;
    @Parameter
    private final String downloadURL;
    @Parameter
    private final String issuedDate;
    @Parameter
    private final String modifiedDate;
    @Parameter
    private final java.util.List<String> labels;
    @Parameter
    private final String datasetDescription;
    @Parameter
    private final java.util.List<BaseEntity> wasDerivedFrom;
    private final LocalDateTime invocationTime;
    private Parameters.Parameters params;
    private Locations.Locations locations;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public RSAKeyPair singleKeyPairFromPKCS12() {
        return SigningHelpers.singleKeyPairFromPKCS12$(this);
    }

    @Override
    public Try<PKCS12File> openPKCS12() {
        return SigningHelpers.openPKCS12$(this);
    }

    @Override
    public Try<String> pkcs12Password() {
        return SigningHelpers.pkcs12Password$(this);
    }

    @Override
    public String canonicalPath() {
        return SigningHelpers.canonicalPath$(this);
    }

    @Override
    public String askForPassword() {
        return SigningHelpers.askForPassword$(this);
    }

    @Override
    public boolean isParent() {
        return Properties.isParent$(this);
    }

    @Override
    public File getDataIdFile() {
        return Properties.getDataIdFile$(this);
    }

    @Override
    public better.files.File dataIdFile() {
        return Properties.dataIdFile$(this);
    }

    @Override
    public better.files.File dataIdPackageTarget() {
        return Properties.dataIdPackageTarget$(this);
    }

    @Override
    public String dataIdDownloadLocation() {
        return Properties.dataIdDownloadLocation$(this);
    }

    @Override
    public File getParseLogFile() {
        return Properties.getParseLogFile$(this);
    }

    @Override
    public File getFeedFile() {
        return Properties.getFeedFile$(this);
    }

    @Override
    public File getDataIdDirectory() {
        return Properties.getDataIdDirectory$(this);
    }

    @Override
    public File getParselogDirectory() {
        return Properties.getParselogDirectory$(this);
    }

    @Override
    public File getFeedDirectory() {
        return Properties.getFeedDirectory$(this);
    }

    @Override
    public File getPackageDirectory() {
        return Properties.getPackageDirectory$(this);
    }

    @Override
    public better.files.File packageSubdirectory() {
        return Properties.packageSubdirectory$(this);
    }

    @Override
    public File getDatafileFinal(File datafile) {
        return Properties.getDatafileFinal$(this, datafile);
    }

    @Override
    public File getDatafilePackageTarget(File datafile) {
        return Properties.getDatafilePackageTarget$(this, datafile);
    }

    @Override
    public List<File> getListOfDataFiles() {
        return Properties.getListOfDataFiles$(this);
    }

    private Logger logger$lzycompute() {
        Validate validate = this;
        synchronized (validate) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String artifactId() {
        return this.artifactId;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String packaging() {
        return this.packaging;
    }

    @Override
    public File mavenTargetDirectory() {
        return this.mavenTargetDirectory;
    }

    @Override
    public String finalName() {
        return this.finalName;
    }

    @Override
    public String multiModuleBaseDirectory() {
        return this.multiModuleBaseDirectory;
    }

    @Override
    public File dataInputDirectory() {
        return this.dataInputDirectory;
    }

    @Override
    public File packageDirectory() {
        return this.packageDirectory;
    }

    @Override
    public File dataDependencyDirectory() {
        return this.dataDependencyDirectory;
    }

    @Override
    public File pluginDirectory() {
        return this.pluginDirectory;
    }

    @Override
    public boolean includeParseLogs() {
        return this.includeParseLogs;
    }

    @Override
    public String bundle() {
        return this.bundle;
    }

    @Override
    public URL downloadUrlPath() {
        return this.downloadUrlPath;
    }

    @Override
    public boolean allowOverwriteOnDeploy() {
        return this.allowOverwriteOnDeploy;
    }

    @Override
    public boolean deployToTestRepo() {
        return this.deployToTestRepo;
    }

    @Override
    public String feedFrom() {
        return this.feedFrom;
    }

    @Override
    public boolean skipHashing() {
        return this.skipHashing;
    }

    @Override
    public File pkcs12File() {
        return this.pkcs12File;
    }

    @Override
    public URL maintainer() {
        return this.maintainer;
    }

    @Override
    public URL publisher() {
        return this.publisher;
    }

    @Override
    public String license() {
        return this.license;
    }

    @Override
    public String downloadURL() {
        return this.downloadURL;
    }

    @Override
    public String issuedDate() {
        return this.issuedDate;
    }

    @Override
    public String modifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public java.util.List<String> labels() {
        return this.labels;
    }

    @Override
    public String datasetDescription() {
        return this.datasetDescription;
    }

    @Override
    public java.util.List<BaseEntity> wasDerivedFrom() {
        return this.wasDerivedFrom;
    }

    @Override
    public LocalDateTime invocationTime() {
        return this.invocationTime;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$artifactId_$eq(String x$1) {
        this.artifactId = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$version_$eq(String x$1) {
        this.version = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$packaging_$eq(String x$1) {
        this.packaging = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$mavenTargetDirectory_$eq(File x$1) {
        this.mavenTargetDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$finalName_$eq(String x$1) {
        this.finalName = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$multiModuleBaseDirectory_$eq(String x$1) {
        this.multiModuleBaseDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$dataInputDirectory_$eq(File x$1) {
        this.dataInputDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$packageDirectory_$eq(File x$1) {
        this.packageDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$dataDependencyDirectory_$eq(File x$1) {
        this.dataDependencyDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$pluginDirectory_$eq(File x$1) {
        this.pluginDirectory = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$includeParseLogs_$eq(boolean x$1) {
        this.includeParseLogs = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$bundle_$eq(String x$1) {
        this.bundle = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$downloadUrlPath_$eq(URL x$1) {
        this.downloadUrlPath = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$allowOverwriteOnDeploy_$eq(boolean x$1) {
        this.allowOverwriteOnDeploy = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$deployToTestRepo_$eq(boolean x$1) {
        this.deployToTestRepo = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$feedFrom_$eq(String x$1) {
        this.feedFrom = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$skipHashing_$eq(boolean x$1) {
        this.skipHashing = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$pkcs12File_$eq(File x$1) {
        this.pkcs12File = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$maintainer_$eq(URL x$1) {
        this.maintainer = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$publisher_$eq(URL x$1) {
        this.publisher = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$license_$eq(String x$1) {
        this.license = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$downloadURL_$eq(String x$1) {
        this.downloadURL = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$issuedDate_$eq(String x$1) {
        this.issuedDate = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$modifiedDate_$eq(String x$1) {
        this.modifiedDate = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$labels_$eq(java.util.List<String> x$1) {
        this.labels = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$datasetDescription_$eq(String x$1) {
        this.datasetDescription = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$wasDerivedFrom_$eq(java.util.List<BaseEntity> x$1) {
        this.wasDerivedFrom = x$1;
    }

    @Override
    public void org$dbpedia$databus$Properties$_setter_$invocationTime_$eq(LocalDateTime x$1) {
        this.invocationTime = x$1;
    }

    private Parameters.Parameters params$lzycompute() {
        Validate validate = this;
        synchronized (validate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.params = Parameters.params$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.params;
    }

    @Override
    public Parameters.Parameters params() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.params$lzycompute() : this.params;
    }

    private Locations.Locations locations$lzycompute() {
        Validate validate = this;
        synchronized (validate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.locations = Locations.locations$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.locations;
    }

    @Override
    public Locations.Locations locations() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.locations$lzycompute() : this.locations;
    }

    public void execute() throws MojoExecutionException {
        block0: {
            if (!this.isParent()) break block0;
            this.validateWebId();
        }
    }

    public void validateWebId() {
        this.getLog().debug((CharSequence)new StringBuilder(15).append("PKCS12 bundle: ").append(this.locations().pkcs12File().pathAsString()).toString());
        RSAModulusAndExponent modulusExponentFromPKCS12 = new RSAModulusAndExponent(BigInt$.MODULE$.javaBigInteger2bigInt(this.keyPair$1().privateKey().getModulus()), BigInt$.MODULE$.javaBigInteger2bigInt(this.keyPair$1().publicKey().getPublicExponent()));
        Model webIdModel = ModelFactory.createDefaultModel();
        webIdModel.read(this.maintainer().toString());
        this.getLog().debug((CharSequence)new StringBuilder(19).append("Read ").append(webIdModel.size()).append(" triples from ").append(this.maintainer()).toString());
        Option matchingKeyInWebId = modulusExponentFromPKCS12.matchAgainstWebId(webIdModel, this.maintainer().toString(), (Option)new Some((Object)this.getLog()));
        if (matchingKeyInWebId.isDefined()) {
            this.getLog().info((CharSequence)"SUCCESS: Private Key validated against WebID");
        } else {
            this.getLog().error((CharSequence)"FAILURE: Private Key and WebID do not match");
        }
    }

    private final RSAKeyPair keyPair$1() {
        return this.singleKeyPairFromPKCS12();
    }

    public Validate() {
        Locations.$init$(this);
        Parameters.$init$(this);
        Properties.$init$(this);
        SigningHelpers.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

