/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.databus.lib;

import fastparse.Parsed;
import fastparse.ParserInput$;
import fastparse.ParsingRun;
import fastparse.package$;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.MalformedInputException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.maven.plugin.logging.Log;
import org.dbpedia.databus.lib.Compression$;
import org.dbpedia.databus.lib.Datafile$;
import org.dbpedia.databus.parse.LineBasedRioDebugParser$;
import org.dbpedia.databus.shared.authentification.RSAKeyPair;
import org.dbpedia.databus.voc.ApplicationNTriples$;
import org.dbpedia.databus.voc.Format;
import org.dbpedia.databus.voc.Format$;
import org.dbpedia.databus.voc.TextTurtle$;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import resource.ManagedResource;
import resource.Resource$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u0001-\u0011\u0001\u0002R1uC\u001aLG.\u001a\u0006\u0003\u0007\u0011\t1\u0001\\5c\u0015\t)a!A\u0004eCR\f'-^:\u000b\u0005\u001dA\u0011a\u00023ca\u0016$\u0017.\u0019\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!Q1A\u0005\u0002Q\tAAZ5mKV\tQ\u0003\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005\u0011\u0011n\u001c\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0003GS2,\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\u000b\u0019LG.\u001a\u0011\t\u0011\u0001\u0002!\u0011!Q\u0001\n\u0005\n\u0001\u0003\u001d:fm&,w\u000fT5oK\u000e{WO\u001c;\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\rIe\u000e\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005Y1o[5q\u0011\u0006\u001c\b.\u001b8h!\tiq%\u0003\u0002)\u001d\t9!i\\8mK\u0006t\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b1B\u0016\u0002\u00071|w\r\u0005\u0002-k5\tQF\u0003\u0002/_\u00059An\\4hS:<'B\u0001\u00192\u0003\u0019\u0001H.^4j]*\u0011!gM\u0001\u0006[\u00064XM\u001c\u0006\u0003i!\ta!\u00199bG\",\u0017B\u0001\u001c.\u0005\raun\u001a\u0005\u0006q\u0001!I!O\u0001\u0007y%t\u0017\u000e\u001e \u0015\tirt\b\u0011\u000b\u0003wu\u0002\"\u0001\u0010\u0001\u000e\u0003\tAQAK\u001cA\u0004-BQaE\u001cA\u0002UAq\u0001I\u001c\u0011\u0002\u0003\u0007\u0011\u0005C\u0004&oA\u0005\t\u0019\u0001\u0014\t\u0015\t\u0003\u0001\u0013!EDB\u0013%1)A\u0002yIE*\u0012\u0001\u0012\t\u0007\u001b\u0015;U*T/\n\u0005\u0019s!A\u0002+va2,G\u0007\u0005\u0002I\u00176\t\u0011J\u0003\u0002K3\u0005!A.\u00198h\u0013\ta\u0015J\u0001\u0004TiJLgn\u001a\t\u0004\u001dF\u001bV\"A(\u000b\u0005As\u0011AC2pY2,7\r^5p]&\u0011!k\u0014\u0002\u0004'\u0016\f\bC\u0001+\\\u001d\t)\u0016\f\u0005\u0002W\u001d5\tqK\u0003\u0002Y\u0015\u00051AH]8pizJ!A\u0017\b\u0002\rA\u0013X\rZ3g\u0013\taEL\u0003\u0002[\u001dA\u0019alY*\u000f\u0005}\u000bgB\u0001,a\u0013\u0005y\u0011B\u00012\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!A\u00153\u000b\u0005\tt\u0001\u0002\u00034\u0001\u0011\u000b\u0007I\u0011A4\u0002\u0015\u0019LG.\u001a)sK\u001aL\u00070F\u0001T\u0011!I\u0007\u0001#b\u0001\n\u0003Q\u0017\u0001G2p]R,g\u000e\u001e,be&\fg\u000e^#yi\u0016t7/[8ogV\tQ\f\u0003\u0005m\u0001!\u0015\r\u0011\"\u0001k\u0003]1wN]7biZ\u000b'/[1oi\u0016CH/\u001a8tS>t7\u000f\u0003\u0005o\u0001!\u0015\r\u0011\"\u0001k\u0003q\u0019w.\u001c9sKN\u001c\u0018n\u001c8WCJL\u0017M\u001c;FqR,gn]5p]ND!\u0002\u001d\u0001\u0011\u0002#\u001d\r\u0015\"\u0003r\u0003\rAHEM\u000b\u0002eB!Qb];T\u0013\t!hB\u0001\u0004UkBdWM\r\t\u0003mfl\u0011a\u001e\u0006\u0003q\u0012\t1A^8d\u0013\tQxO\u0001\u0004G_Jl\u0017\r\u001e\u0005\ty\u0002A)\u0019!C\u0001{\u00061am\u001c:nCR,\u0012!\u001e\u0005\t\u007f\u0002A)\u0019!C\u0001O\u0006yam\u001c:nCR,\u0005\u0010^3og&|g\u000eC\u0005\u0002\u0004\u0001A)\u0019!C\u0001O\u0006I1\u000f[13kY\u001aX/\u001c\u0005\u000b\u0003\u000f\u0001\u0001R1A\u0005\u0002\u0005%\u0011!\u00022zi\u0016\u001cXCAA\u0006!\ri\u0011QB\u0005\u0004\u0003\u001fq!\u0001\u0002'p]\u001eD!\"a\u0005\u0001\u0011\u000b\u0007I\u0011AA\u000b\u00039\t'o\u00195jm\u00164\u0016M]5b]R,\"!a\u0006\u0011\t5\tIbU\u0005\u0004\u00037q!AB(qi&|g\u000e\u0003\u0006\u0002 \u0001A)\u0019!C\u0001\u0003+\t!cY8naJ,7o]5p]Z\u000b'/[1oi\"1\u00111\u0005\u0001\u0005\u0002\u001d\f\u0001dY8naJ,7o]5p]>\u0013\u0018I]2iSZ,G)Z:d\u0011%\t9\u0003\u0001a\u0001\n\u0003\tI#\u0001\btS\u001et\u0017\r^;sK\nKH/Z:\u0016\u0005\u0005-\u0002#B\u0007\u0002.\u0005E\u0012bAA\u0018\u001d\t)\u0011I\u001d:bsB\u0019Q\"a\r\n\u0007\u0005UbB\u0001\u0003CsR,\u0007\"CA\u001d\u0001\u0001\u0007I\u0011AA\u001e\u0003I\u0019\u0018n\u001a8biV\u0014XMQ=uKN|F%Z9\u0015\t\u0005u\u00121\t\t\u0004\u001b\u0005}\u0012bAA!\u001d\t!QK\\5u\u0011%\u0011\u0015qGA\u0001\u0002\u0004\tY\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0015BA\u0016\u0003=\u0019\u0018n\u001a8biV\u0014XMQ=uKN\u0004\u0003\u0002CA&\u0001\u0001\u0007I\u0011A4\u0002\u001fMLwM\\1ukJ,')Y:fmQB\u0011\"a\u0014\u0001\u0001\u0004%\t!!\u0015\u0002'MLwM\\1ukJ,')Y:fmQzF%Z9\u0015\t\u0005u\u00121\u000b\u0005\t\u0005\u00065\u0013\u0011!a\u0001'\"9\u0011q\u000b\u0001!B\u0013\u0019\u0016\u0001E:jO:\fG/\u001e:f\u0005\u0006\u001cXM\u000e\u001b!\u0011%\tY\u0006\u0001a\u0001\n\u0003\ti&\u0001\u0005wKJLg-[3e+\u00051\u0003\"CA1\u0001\u0001\u0007I\u0011AA2\u000311XM]5gS\u0016$w\fJ3r)\u0011\ti$!\u001a\t\u0011\t\u000by&!AA\u0002\u0019Bq!!\u001b\u0001A\u0003&a%A\u0005wKJLg-[3eA!I\u0011Q\u000e\u0001\t\u0006\u0004%\taZ\u0001\baJ,g/[3x\u0011\u001d\t\t\b\u0001C\u0001\u0003g\nA\"\u001a8tkJ,W\t_5tiN$\u0012a\u000f\u0005\b\u0003o\u0002A\u0011AA=\u0003!\u0011\u0017m]3oC6,G#A*\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u0005ia-\u001b8bY\n\u000b7/\u001a8b[\u0016$2aRAA\u0011!\t\u0019)a\u001fA\u0002\u0005]\u0011\u0001\u0004<feNLwN\u001c+p\u0003\u0012$\u0007bBAD\u0001\u0011%\u0011\u0011R\u0001\u0010G>l\u0007/\u001e;f\u001b&lW\rV=qKR\u0019!/a#\t\u000f\u00055\u0015Q\u0011a\u0001;\u0006qam\u001c:nCR4\u0016M]5b]R\u001c\bbBAI\u0001\u0011%\u00111S\u0001\u0011M&dWM\\1nK\u0006s\u0017\r\\=tSN,\"!!&\u0011\r5)5+X/^\u0011\u0019\tI\n\u0001C\u0005O\u0006q1m\\7qkR,\u0007K]3wS\u0016<\bbBAO\u0001\u0011\u0005\u0011qT\u0001\u0010kB$\u0017\r^3TS\u001et\u0017\r^;sKR\u00191(!)\t\u0011\u0005\r\u00161\u0014a\u0001\u0003K\u000bqa[3z!\u0006L'\u000f\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002!\u0005,H\u000f[3oi&4\u0017nY1uS>t'bAAX\t\u000511\u000f[1sK\u0012LA!a-\u0002*\nQ!kU!LKf\u0004\u0016-\u001b:\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\u0006qq-\u001a;J]B,Ho\u0015;sK\u0006lGCAA^!\u0019\ti,a1\u0002H6\u0011\u0011q\u0018\u0006\u0003\u0003\u0003\f\u0001B]3t_V\u00148-Z\u0005\u0005\u0003\u000b\fyLA\bNC:\fw-\u001a3SKN|WO]2f!\r1\u0012\u0011Z\u0005\u0004\u0003\u0017<\"aC%oaV$8\u000b\u001e:fC6Dq!a4\u0001\t\u0003\nI(\u0001\u0005u_N#(/\u001b8h\u000f\u001d\t\u0019N\u0001E\u0001\u0003+\f\u0001\u0002R1uC\u001aLG.\u001a\t\u0004y\u0005]gAB\u0001\u0003\u0011\u0003\tInE\u0003\u0002X2\tY\u000e\u0005\u0003\u0002^\u0006-XBAAp\u0015\u0011\t\t/a9\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005\u0015\u0018q]\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011^\u0001\u0004G>l\u0017\u0002BAw\u0003?\u00141\u0002T1{s2{wmZ5oO\"9\u0001(a6\u0005\u0002\u0005EHCAAk\u0011!\t)0a6\u0005\u0002\u0005]\u0018!B1qa2LH\u0003CA}\u0003{\fyP!\u0001\u0015\u0007m\nY\u0010\u0003\u0004+\u0003g\u0004\u001da\u000b\u0005\u0007'\u0005M\b\u0019A\u000b\t\u0011\u0001\n\u0019\u0010%AA\u0002\u0005B\u0001\"JAz!\u0003\u0005\rA\n\u0005\t\u0005\u000b\t9\u000e\"\u0005\u0003\b\u0005i\u0011\r\u001c9iC:+X.\u001a:jGB+BA!\u0003\u00030Q!!1\u0002B\u000e!\u0019\u0011iAa\u0006\u0002>A!!q\u0002B\u000b\u001b\t\u0011\tB\u0003\u0002\u0003\u0014\u0005Ia-Y:ua\u0006\u00148/\u001a\u0006\u0004E\nE\u0011\u0002\u0002B\r\u0005+\u0011\u0011\u0001\u0015\u0005\u000b\u0005;\u0011\u0019!!AA\u0004\t}\u0011AC3wS\u0012,gnY3%cA1!\u0011\u0005B\f\u0005SqAAa\t\u0003(9\u0019aK!\n\n\u0005\tM\u0011b\u00012\u0003\u0012A\u0019QBa\u000b\n\u0007\t5bBA\u0002B]f$\u0001B!\r\u0003\u0004\t\u0007!1\u0007\u0002\u0002?F!!Q\u0007B\u0015!\ri!qG\u0005\u0004\u0005sq!a\u0002(pi\"Lgn\u001a\u0005\t\u0005{\t9\u000e\"\u0005\u0003@\u0005i\u0011M\u001d;jM\u0006\u001cGOT1nKB+BA!\u0011\u0003JQ!!1\tB#!\u0015\u0011iAa\u0006T\u0011)\u00119Ea\u000f\u0002\u0002\u0003\u000f!qD\u0001\u000bKZLG-\u001a8dK\u0012\u0012D\u0001\u0003B\u0019\u0005w\u0011\rAa\r\t\u0011\t5\u0013q\u001bC\t\u0005\u001f\n\u0001cY8oi\u0016tGOV1sS\u0006tGo\u001d)\u0016\t\tE#\u0011\f\u000b\u0005\u0005'\u0012)\u0006E\u0003\u0003\u000e\t]Q\f\u0003\u0006\u0003X\t-\u0013\u0011!a\u0002\u0005?\t!\"\u001a<jI\u0016t7-\u001a\u00134\t!\u0011\tDa\u0013C\u0002\tM\u0002\u0002\u0003B/\u0003/$\tBa\u0018\u0002\u0015\u0015DH/\u001a8tS>t\u0007+\u0006\u0003\u0003b\t%D\u0003\u0002B2\u0005K\u0002RA!\t\u0003\u0018MC!Ba\u001a\u0003\\\u0005\u0005\t9\u0001B\u0010\u0003))g/\u001b3f]\u000e,G\u0005\u000e\u0003\t\u0005c\u0011YF1\u0001\u00034!A!QNAl\t#\u0011y'\u0001\tg_Jl\u0017\r^#yi\u0016t7/[8o!V!!\u0011\u000fB<)\u0011\u0011\u0019Ea\u001d\t\u0015\tU$1NA\u0001\u0002\b\u0011y\"\u0001\u0006fm&$WM\\2fIU\"\u0001B!\r\u0003l\t\u0007!1\u0007\u0005\t\u0005w\n9\u000e\"\u0005\u0003~\u0005\tbm\u001c:nCR,\u0005\u0010^3og&|gn\u001d)\u0016\t\t}$Q\u0011\u000b\u0005\u0005'\u0012\t\t\u0003\u0006\u0003\u0004\ne\u0014\u0011!a\u0002\u0005?\t!\"\u001a<jI\u0016t7-\u001a\u00137\t!\u0011\tD!\u001fC\u0002\tM\u0002\u0002\u0003BE\u0003/$\tBa#\u0002+\r|W\u000e\u001d:fgNLwN\\#yi\u0016t7/[8o!V!!Q\u0012BJ)\u0011\u0011\u0019Ea$\t\u0015\tE%qQA\u0001\u0002\b\u0011y\"\u0001\u0006fm&$WM\\2fI]\"\u0001B!\r\u0003\b\n\u0007!1\u0007\u0005\t\u0005/\u000b9\u000e\"\u0005\u0003\u001a\u000612m\\7qe\u0016\u001c8/[8o\u000bb$XM\\:j_:\u001c\b+\u0006\u0003\u0003\u001c\n\u0005F\u0003\u0002B*\u0005;C!Ba(\u0003\u0016\u0006\u0005\t9\u0001B\u0010\u0003))g/\u001b3f]\u000e,G\u0005\u000f\u0003\t\u0005c\u0011)J1\u0001\u00034!A!QUAl\t#\u00119+A\u000beCR\f'-^:J]B,HOR5mK:\fW.\u001a)\u0016\t\t%&\u0011\u0017\u000b\u0005\u0005W\u0013i\u000b\u0005\u0004\u0003\"\t]\u0011Q\u0013\u0005\u000b\u0005_\u0013\u0019+!AA\u0004\t}\u0011AC3wS\u0012,gnY3%s\u0011A!\u0011\u0007BR\u0005\u0004\u0011\u0019\u0004\u0003\u0006\u00036\u0006]\u0017\u0013!C\u0001\u0005o\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0005sS3!\tB^W\t\u0011i\f\u0005\u0003\u0003@\n%WB\u0001Ba\u0015\u0011\u0011\u0019M!2\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bd\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-'\u0011\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003Bh\u0003/\f\n\u0011\"\u0001\u0003R\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u0003T*\u001aaEa/\t\u0015\t]\u0017q[I\u0001\n\u0013\u00119,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0005\u000b\u00057\f9.%A\u0005\n\tE\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007")
public class Datafile {
    private Tuple4<String, Seq<String>, Seq<String>, Seq<String>> x$1;
    private String filePrefix;
    private Seq<String> contentVariantExtensions;
    private Seq<String> formatVariantExtensions;
    private Seq<String> compressionVariantExtensions;
    private Tuple2<Format, String> x$2;
    private Format format;
    private String formatExtension;
    private String sha256sum;
    private long bytes;
    private Option<String> archiveVariant;
    private Option<String> compressionVariant;
    private String preview;
    private final File file;
    private final int previewLineCount;
    private final boolean skipHashing;
    private final Log log;
    private byte[] signatureBytes;
    private String signatureBase64;
    private boolean verified;
    private volatile int bitmap$0;

    public static boolean apply$default$3() {
        return Datafile$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return Datafile$.MODULE$.apply$default$2();
    }

    public static <_> ParsingRun<Tuple4<String, Seq<String>, Seq<String>, Seq<String>>> databusInputFilenameP(ParsingRun<Object> parsingRun) {
        return Datafile$.MODULE$.databusInputFilenameP(parsingRun);
    }

    public static Datafile apply(File file, int n, boolean bl, Log log) {
        return Datafile$.MODULE$.apply(file, n, bl, log);
    }

    public File file() {
        return this.file;
    }

    private Tuple4<String, Seq<String>, Seq<String>, Seq<String>> x$1$lzycompute() {
        block5: {
            Datafile datafile = this;
            synchronized (datafile) {
                Seq seq;
                String string;
                Seq compressionVariantExtensions;
                Seq formatVariantExtensions;
                block7: {
                    Tuple4<String, Seq<String>, Seq<String>, Seq<String>> tuple4;
                    block6: {
                        if ((this.bitmap$0 & 1) != 0) break block5;
                        tuple4 = this.filenameAnalysis();
                        if (tuple4 == null) break block6;
                        String filePrefix = (String)tuple4._1();
                        Seq contentVariantExtensions = (Seq)tuple4._2();
                        formatVariantExtensions = (Seq)tuple4._3();
                        compressionVariantExtensions = (Seq)tuple4._4();
                        if (filePrefix == null) break block6;
                        string = filePrefix;
                        if (contentVariantExtensions == null) break block6;
                        seq = contentVariantExtensions;
                        if (formatVariantExtensions != null) break block7;
                    }
                    throw new MatchError(tuple4);
                }
                Seq seq2 = formatVariantExtensions;
                Tuple4 tuple4 = new Tuple4((Object)string, (Object)seq, (Object)seq2, (Object)compressionVariantExtensions);
                this.x$1 = tuple4;
                this.bitmap$0 |= 1;
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple4 x$1() {
        return (this.bitmap$0 & 1) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private String filePrefix$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 2) == 0) {
                this.filePrefix = (String)this.x$1()._1();
                this.bitmap$0 |= 2;
            }
        }
        return this.filePrefix;
    }

    public String filePrefix() {
        return (this.bitmap$0 & 2) == 0 ? this.filePrefix$lzycompute() : this.filePrefix;
    }

    private Seq<String> contentVariantExtensions$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 4) == 0) {
                this.contentVariantExtensions = (Seq)this.x$1()._2();
                this.bitmap$0 |= 4;
            }
        }
        return this.contentVariantExtensions;
    }

    public Seq<String> contentVariantExtensions() {
        return (this.bitmap$0 & 4) == 0 ? this.contentVariantExtensions$lzycompute() : this.contentVariantExtensions;
    }

    private Seq<String> formatVariantExtensions$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 8) == 0) {
                this.formatVariantExtensions = (Seq)this.x$1()._3();
                this.bitmap$0 |= 8;
            }
        }
        return this.formatVariantExtensions;
    }

    public Seq<String> formatVariantExtensions() {
        return (this.bitmap$0 & 8) == 0 ? this.formatVariantExtensions$lzycompute() : this.formatVariantExtensions;
    }

    private Seq<String> compressionVariantExtensions$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.compressionVariantExtensions = (Seq)this.x$1()._4();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.compressionVariantExtensions;
    }

    public Seq<String> compressionVariantExtensions() {
        return (this.bitmap$0 & 0x10) == 0 ? this.compressionVariantExtensions$lzycompute() : this.compressionVariantExtensions;
    }

    private Tuple2<Format, String> x$2$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x20) == 0) {
                Tuple2<Format, String> tuple2 = this.computeMimeType(this.formatVariantExtensions());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Format format = (Format)tuple2._1();
                String formatExtension = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)format, (Object)formatExtension);
                this.x$2 = tuple22;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.x$2;
    }

    private /* synthetic */ Tuple2 x$2() {
        return (this.bitmap$0 & 0x20) == 0 ? this.x$2$lzycompute() : this.x$2;
    }

    private Format format$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.format = (Format)this.x$2()._1();
                this.bitmap$0 |= 0x40;
            }
        }
        return this.format;
    }

    public Format format() {
        return (this.bitmap$0 & 0x40) == 0 ? this.format$lzycompute() : this.format;
    }

    private String formatExtension$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.formatExtension = (String)this.x$2()._2();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.formatExtension;
    }

    public String formatExtension() {
        return (this.bitmap$0 & 0x80) == 0 ? this.formatExtension$lzycompute() : this.formatExtension;
    }

    private String sha256sum$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.sha256sum = this.skipHashing ? "" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(org.dbpedia.databus.shared.signing.package$.MODULE$.sha256Hash(better.files.package$.MODULE$.FileOps(this.file()).toScala()).asBytes())).map((Function1 & Serializable & scala.Serializable)x$3 -> Datafile.$anonfun$sha256sum$1(BoxesRunTime.unboxToByte((Object)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.sha256sum;
    }

    public String sha256sum() {
        return (this.bitmap$0 & 0x100) == 0 ? this.sha256sum$lzycompute() : this.sha256sum;
    }

    private long bytes$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.bytes = this.file().length();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.bytes;
    }

    public long bytes() {
        return (this.bitmap$0 & 0x200) == 0 ? this.bytes$lzycompute() : this.bytes;
    }

    private Option<String> archiveVariant$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.archiveVariant = Compression$.MODULE$.detectArchive(better.files.package$.MODULE$.FileOps(this.file()).toScala());
                this.bitmap$0 |= 0x400;
            }
        }
        return this.archiveVariant;
    }

    public Option<String> archiveVariant() {
        return (this.bitmap$0 & 0x400) == 0 ? this.archiveVariant$lzycompute() : this.archiveVariant;
    }

    private Option<String> compressionVariant$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.compressionVariant = Compression$.MODULE$.detectCompression(better.files.package$.MODULE$.FileOps(this.file()).toScala());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.compressionVariant;
    }

    public Option<String> compressionVariant() {
        return (this.bitmap$0 & 0x800) == 0 ? this.compressionVariant$lzycompute() : this.compressionVariant;
    }

    public String compressionOrArchiveDesc() {
        return (String)((TraversableLike)((Stream)scala.package$.MODULE$.Stream().empty().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.compressionVariant()), Stream$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.archiveVariant()), Stream$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None");
    }

    public byte[] signatureBytes() {
        return this.signatureBytes;
    }

    public void signatureBytes_$eq(byte[] x$1) {
        this.signatureBytes = x$1;
    }

    public String signatureBase64() {
        return this.signatureBase64;
    }

    public void signatureBase64_$eq(String x$1) {
        this.signatureBase64 = x$1;
    }

    public boolean verified() {
        return this.verified;
    }

    public void verified_$eq(boolean x$1) {
        this.verified = x$1;
    }

    private String preview$lzycompute() {
        Datafile datafile = this;
        synchronized (datafile) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.preview = this.computePreview();
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.preview;
    }

    public String preview() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.preview$lzycompute() : this.preview;
    }

    public Datafile ensureExists() {
        if (this.file().exists()) {
            Seq x$8;
            better.files.File qual$1 = better.files.package$.MODULE$.FileOps(this.file()).toScala();
            if (!qual$1.isRegularFile(x$8 = qual$1.isRegularFile$default$1())) {
                throw new FileNotFoundException(new StringBuilder(22).append(this.file().getAbsolutePath()).append(" is not a regular file").toString());
            }
        } else {
            throw new FileNotFoundException(new StringBuilder(16).append("File not found: ").append(this.file().getAbsolutePath()).toString());
        }
        return this;
    }

    public String basename() {
        return this.file().getName();
    }

    public String finalBasename(Option<String> versionToAdd) {
        return new StringBuilder(0).append(this.prefix$1(versionToAdd)).append(this.contentVariantsSuffix$1()).append(this.formatVariantsSuffix$1()).append(this.compressionVariantsSuffix$1()).toString();
    }

    private Tuple2<Format, String> computeMimeType(Seq<String> formatVariants) {
        Format format;
        Format mimeTypeByFileName;
        Tuple2<String, Format> tuple2 = Format$.MODULE$.detectMimeTypeByFileExtension(formatVariants, this.log);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String ext = (String)tuple2._1();
        Format mimeTypeByFileName2 = (Format)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ext, (Object)mimeTypeByFileName2);
        Tuple2 tuple23 = tuple22;
        String ext2 = (String)tuple23._1();
        Format format2 = mimeTypeByFileName = (Format)tuple23._2();
        TextTurtle$ textTurtle$ = TextTurtle$.MODULE$;
        if (!(format2 != null ? !format2.equals(textTurtle$) : textTurtle$ != null)) {
            HashSet wrongTriples;
            ByteArrayInputStream baos = new ByteArrayInputStream(this.preview().getBytes());
            Tuple4<Integer, Integer, Integer, HashSet<String>> tuple4 = LineBasedRioDebugParser$.MODULE$.parse(baos, Rio.createParser((RDFFormat)ApplicationNTriples$.MODULE$.rio()));
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            HashSet hashSet = wrongTriples = (HashSet)tuple4._4();
            HashSet wrongTriples2 = hashSet;
            format = wrongTriples2.isEmpty() ? ApplicationNTriples$.MODULE$ : mimeTypeByFileName;
        } else {
            format = mimeTypeByFileName;
        }
        Format mimeType = format;
        return new Tuple2((Object)mimeType, (Object)ext2);
    }

    private Tuple4<String, Seq<String>, Seq<String>, Seq<String>> filenameAnalysis() {
        Tuple4 basenameParts;
        Parsed parsed = package$.MODULE$.parse(ParserInput$.MODULE$.fromString(this.basename()), (Function1 & Serializable & scala.Serializable)x$5 -> Datafile$.MODULE$.databusInputFilenameP((ParsingRun<Object>)x$5), package$.MODULE$.parse$default$3(), package$.MODULE$.parse$default$4(), package$.MODULE$.parse$default$5());
        if (!(parsed instanceof Parsed.Success)) {
            if (parsed instanceof Parsed.Failure) {
                Parsed.Failure failure = (Parsed.Failure)parsed;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(133).append("Unable to analyse filename '").append(this.basename()).append("': Please refer to ").append("http://dev.dbpedia.org/Databus%20Maven%20Plugin on conventions for input file naming:\n").append(failure.trace().longAggregateMsg()).toString());
            }
            throw new MatchError((Object)parsed);
        }
        Parsed.Success success = (Parsed.Success)parsed;
        Tuple4 tuple4 = basenameParts = (Tuple4)success.value();
        return tuple4;
    }

    private String computePreview() {
        ManagedResource unshortenedPreview = this.getInputStream().flatMap((Function1 & Serializable & scala.Serializable)inputStream -> resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.UTF8()), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(BufferedSource.class)).map((Function1 & Serializable & scala.Serializable)source -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> source.getLines().take($this.previewLineCount).mkString("\n"))));
        return (String)unshortenedPreview.apply((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Success success = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                String tooLong = (String)success.value();
                if (new StringOps(Predef$.MODULE$.augmentString(tooLong)).size() > this.maxLength$1()) {
                    return tooLong.substring(0, this.maxLength$1());
                }
            }
            if (bl) {
                String shortEnough = (String)success.value();
                return shortEnough;
            }
            if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
            Failure failure = (Failure)try_;
            Throwable mie = failure.exception();
            if (!(mie instanceof MalformedInputException)) throw new MatchError((Object)try_);
            return "[binary data - no preview]";
        });
    }

    public Datafile updateSignature(RSAKeyPair keyPair) {
        this.signatureBytes_$eq(org.dbpedia.databus.shared.signing.package$.MODULE$.signFile((PrivateKey)keyPair.privateKey(), better.files.package$.MODULE$.FileOps(this.file()).toScala(), org.dbpedia.databus.shared.signing.package$.MODULE$.signFile$default$3(), org.dbpedia.databus.shared.signing.package$.MODULE$.signFile$default$4()));
        this.signatureBase64_$eq(new String(Base64.getEncoder().encode(this.signatureBytes())));
        this.verified_$eq(org.dbpedia.databus.shared.signing.package$.MODULE$.verifyFile((PublicKey)keyPair.publicKey(), this.signatureBytes(), better.files.package$.MODULE$.FileOps(this.file()).toScala(), org.dbpedia.databus.shared.signing.package$.MODULE$.verifyFile$default$4(), org.dbpedia.databus.shared.signing.package$.MODULE$.verifyFile$default$5()));
        return this;
    }

    public ManagedResource<InputStream> getInputStream() {
        return resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> {
            void var1_10;
            better.files.File qual$2 = better.files.package$.MODULE$.FileOps(this.file()).toScala();
            Seq x$9 = qual$2.newInputStream$default$1();
            BufferedInputStream bis = better.files.package$.MODULE$.InputStreamOps(qual$2.newInputStream(x$9)).buffered();
            Tuple2 tuple2 = new Tuple2(this.compressionVariant(), this.archiveVariant());
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some && None$.MODULE$.equals(option2)) {
                    CompressorInputStream compressorInputStream = new CompressorStreamFactory().createCompressorInputStream((InputStream)bis);
                    return var1_10;
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                    ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);
                    return var1_10;
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option4)) {
                    BufferedInputStream bufferedInputStream = bis;
                    return var1_10;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
            Some some = (Some)option;
            String comp = (String)some.value();
            if (!(option5 instanceof Some)) throw new MatchError((Object)tuple2);
            Some some2 = (Some)option5;
            String arch = (String)some2.value();
            throw scala.sys.package$.MODULE$.error(new StringBuilder(51).append("file seems to be both compressed and an archive: ").append(comp).append(", ").append(arch).toString());
        }, Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class));
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(185).append("\n       |Datafile(format=").append(this.format()).append("\n       |sha256sum=").append(this.sha256sum()).append("\n       |bytes=").append(this.bytes()).append("\n       |archiveVariant=").append(this.archiveVariant()).append("\n       |compressionVariant=").append(this.compressionVariant()).append("\n       |signatureBytes=").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.signatureBytes())).map((Function1 & Serializable & scala.Serializable)x$6 -> Datafile.$anonfun$toString$1(BoxesRunTime.unboxToByte((Object)x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString()).append("\n       |signatureBase64=").append(this.signatureBase64()).append("\n       |verified=").append(this.verified()).append(")\n     ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$sha256sum$1(byte x$3) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$3)}));
    }

    private final String prefix$1(Option versionToAdd$1) {
        return (String)versionToAdd$1.fold((Function0 & Serializable & scala.Serializable)() -> this.filePrefix(), (Function1 & Serializable & scala.Serializable)version -> new StringBuilder(1).append(this.filePrefix()).append("-").append((String)version).toString());
    }

    private final String contentVariantsSuffix$1() {
        return this.contentVariantExtensions().nonEmpty() ? this.contentVariantExtensions().mkString("_", "_", "") : "";
    }

    private final String formatVariantsSuffix$1() {
        return this.formatVariantExtensions().nonEmpty() ? this.formatVariantExtensions().mkString(".", ".", "") : "";
    }

    private final String compressionVariantsSuffix$1() {
        return this.compressionVariantExtensions().nonEmpty() ? this.compressionVariantExtensions().mkString(".", ".", "") : "";
    }

    private final int maxLength$1() {
        return this.previewLineCount * 500;
    }

    public static final /* synthetic */ String $anonfun$toString$1(byte x$6) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$6)}));
    }

    public Datafile(File file, int previewLineCount, boolean skipHashing, Log log) {
        this.file = file;
        this.previewLineCount = previewLineCount;
        this.skipHashing = skipHashing;
        this.log = log;
        this.signatureBytes = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        this.signatureBase64 = "";
        this.verified = false;
    }
}

