/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.databus.shared;

import better.files.File;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLContext;
import org.dbpedia.databus.shared.DataIdUpload$UploadParams$;
import org.dbpedia.databus.shared.DataIdUpload$UploadPartNames$;
import org.dbpedia.databus.shared.authentification.PKCS12File;
import org.dbpedia.databus.shared.authentification.PKCS12File$;
import org.dbpedia.databus.shared.authentification.RSAKeyPair;
import org.dbpedia.databus.shared.tls.package$;
import resource.ManagedResource;
import resource.Resource$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scalaj.http.BaseHttp;
import scalaj.http.HttpResponse;
import scalaj.http.MultiPart;
import scalaj.http.MultiPart$;

public final class DataIdUpload$
implements LazyLogging {
    public static DataIdUpload$ MODULE$;
    private Set<String> expectedPartsForUpload;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DataIdUpload$();
    }

    private Logger logger$lzycompute() {
        DataIdUpload$ dataIdUpload$ = this;
        synchronized (dataIdUpload$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public HttpResponse<String> upload(String uploadEndpointIRI, File dataIdFile, File pkcs12File, String pkcs12Password, String dataIdTargetLocation, boolean allowOverwrite) {
        return this.upload(uploadEndpointIRI, (Function0<ManagedResource<InputStream>>)(Function0 & Serializable & scala.Serializable)() -> resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> dataIdFile.newInputStream(dataIdFile.newInputStream$default$1()), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class)), (Function0<ManagedResource<InputStream>>)(Function0 & Serializable & scala.Serializable)() -> resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> pkcs12File.newInputStream(pkcs12File.newInputStream$default$1()), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class)), pkcs12File.pathAsString(), pkcs12Password, dataIdTargetLocation, allowOverwrite);
    }

    public HttpResponse<String> upload(String uploadEndpointIRI, byte[] dataIdBytes, File pkcs12File, String pkcs12Password, String dataIdTargetLocation, boolean allowOverwrite) {
        return this.upload(uploadEndpointIRI, (Function0<ManagedResource<InputStream>>)(Function0 & Serializable & scala.Serializable)() -> resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(dataIdBytes), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ByteArrayInputStream.class)), (Function0<ManagedResource<InputStream>>)(Function0 & Serializable & scala.Serializable)() -> resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> pkcs12File.newInputStream(pkcs12File.newInputStream$default$1()), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class)), pkcs12File.pathAsString(), pkcs12Password, dataIdTargetLocation, allowOverwrite);
    }

    public HttpResponse<String> upload(String uploadEndpointIRI, Function0<ManagedResource<InputStream>> dataIdStreamOpener, Function0<ManagedResource<InputStream>> pkcs12StreamOpener, String pkcs12SourceDesc, String pkcs12Password, String dataIdTargetLocation, boolean allowOverwrite) {
        int dataIdSize = BoxesRunTime.unboxToInt((Object)((ManagedResource)dataIdStreamOpener.apply()).acquireAndGet((Function1 & Serializable & scala.Serializable)is -> BoxesRunTime.boxToInteger((int)DataIdUpload$.$anonfun$upload$9(is))));
        return (HttpResponse)((ManagedResource)dataIdStreamOpener.apply()).and((ManagedResource)dataIdStreamOpener.apply()).apply((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            InputStream dataIdForSign;
            InputStream dataIdForSend;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                dataIdForSend = (InputStream)tuple22._1();
                dataIdForSign = (InputStream)tuple22._2();
                SSLContext sslContext = package$.MODULE$.pkcs12ClientCertSslContext((ManagedResource<InputStream>)((ManagedResource)pkcs12StreamOpener.apply()), pkcs12Password);
                PKCS12File pkcs12 = PKCS12File$.MODULE$.fromStream((ManagedResource<InputStream>)((ManagedResource)pkcs12StreamOpener.apply()), pkcs12SourceDesc, pkcs12Password);
                RSAKeyPair rSAKeyPair = (RSAKeyPair)pkcs12.rsaKeyPairs().head();
                if (rSAKeyPair == null) {
                    throw new MatchError((Object)rSAKeyPair);
                }
                RSAPublicKey publicKey = rSAKeyPair.publicKey();
                RSAPrivateKey privateKey = rSAKeyPair.privateKey();
                tuple2 = new Tuple2((Object)publicKey, (Object)privateKey);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            RSAPublicKey publicKey = (RSAPublicKey)tuple23._1();
            RSAPrivateKey privateKey = (RSAPrivateKey)tuple23._2();
            Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataIdUpload$UploadParams$.MODULE$.dataIdLocation()), (Object)dataIdTargetLocation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataIdUpload$UploadParams$.MODULE$.allowOverwrite()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString())}));
            BaseHttp sslHttp = package$.MODULE$.scalajHttpWithClientCert((ManagedResource<InputStream>)((ManagedResource)pkcs12StreamOpener.apply()), pkcs12Password);
            HttpResponse httpResponse = sslHttp.apply(uploadEndpointIRI).postMulti((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MultiPart[]{DataIdUpload$.dataIdPart$1(dataIdTargetLocation, dataIdSize, dataIdForSend), DataIdUpload$.signaturePart$1(dataIdForSign, privateKey), DataIdUpload$.paramsPart$1(params)})).asString();
            return httpResponse;
        });
    }

    private Set<String> expectedPartsForUpload$lzycompute() {
        DataIdUpload$ dataIdUpload$ = this;
        synchronized (dataIdUpload$) {
            if (!this.bitmap$0) {
                this.expectedPartsForUpload = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DataIdUpload$UploadPartNames$.MODULE$.dataId(), DataIdUpload$UploadPartNames$.MODULE$.dataIdSignature(), DataIdUpload$UploadPartNames$.MODULE$.uploadParams()}));
                this.bitmap$0 = true;
            }
        }
        return this.expectedPartsForUpload;
    }

    public Set<String> expectedPartsForUpload() {
        return !this.bitmap$0 ? this.expectedPartsForUpload$lzycompute() : this.expectedPartsForUpload;
    }

    public static final /* synthetic */ int $anonfun$upload$9(InputStream is) {
        return scala.package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> is.read()).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != -1).size();
    }

    private static final MultiPart dataIdPart$1(String dataIdTargetLocation$1, int dataIdSize$1, InputStream dataIdForSend$1) {
        return new MultiPart(DataIdUpload$UploadPartNames$.MODULE$.dataId(), "dataid.ttl", "text/turtle", dataIdForSend$1, (long)dataIdSize$1, (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)bytesWritten -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("{} bytes written for {}", new Object[]{BoxesRunTime.boxToLong((long)bytesWritten), dataIdTargetLocation$1});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    private static final MultiPart signaturePart$1(InputStream dataIdForSign$1, RSAPrivateKey privateKey$1) {
        return MultiPart$.MODULE$.apply(DataIdUpload$UploadPartNames$.MODULE$.dataIdSignature(), "dataid.ttl.sig", "application/pkcs7-signature", org.dbpedia.databus.shared.signing.package$.MODULE$.signInputStream(privateKey$1, dataIdForSign$1, org.dbpedia.databus.shared.signing.package$.MODULE$.signInputStream$default$3(), org.dbpedia.databus.shared.signing.package$.MODULE$.signInputStream$default$4()));
    }

    private static final Function1 encode$1() {
        return (Function1 & Serializable & scala.Serializable)x$3 -> URLEncoder.encode(x$3, StandardCharsets.UTF_8.name());
    }

    private static final String encodedParamsQueryString$1(Map params$1) {
        return ((TraversableOnce)params$1.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(DataIdUpload$.encode$1().apply((Object)v)).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("&");
    }

    private static final MultiPart paramsPart$1(Map params$1) {
        return MultiPart$.MODULE$.apply(DataIdUpload$UploadPartNames$.MODULE$.uploadParams(), "dataid.params", "application/x-www-form-urlencoded", DataIdUpload$.encodedParamsQueryString$1(params$1));
    }

    private DataIdUpload$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

