/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.Quad$;
import org.dbpedia.extraction.scripts.DateFinder;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Console$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class QuadReader$ {
    public static final QuadReader$ MODULE$;

    static {
        new QuadReader$();
    }

    public <T> void readQuads(DateFinder<T> finder, String input, boolean auto, Function1<Quad, BoxedUnit> proc, Function1<T, FileLike<T>> evidence$1) {
        this.readQuads(finder.language().wikiCode(), (FileLike)evidence$1.apply(finder.find(input, auto)), proc);
    }

    public void readQuads(String tag, FileLike<?> file, Function1<Quad, BoxedUnit> proc) {
        Console$.MODULE$.err().println(new StringBuilder().append((Object)tag).append((Object)": reading ").append(file).append((Object)" ...").toString());
        IntRef lineCount = new IntRef(0);
        long start = System.nanoTime();
        IOUtils$.MODULE$.readLines(file, IOUtils$.MODULE$.readLines$default$2(), (Function1)new Serializable(tag, proc, lineCount, start){
            public static final long serialVersionUID = 0L;
            private final String tag$1;
            private final Function1 proc$1;
            private final IntRef lineCount$1;
            private final long start$1;

            public final void apply(String line) {
                String string = line;
                if (string == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Option option = Quad$.MODULE$.unapply(string);
                    if (option.isEmpty()) {
                        if (new StringOps(Predef$.MODULE$.augmentString(string)).nonEmpty() && !string.startsWith("#")) {
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"line did not match quad or triple syntax: ").append((Object)line).toString());
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit;
                        Quad quad = (Quad)option.get();
                        this.proc$1.apply((Object)quad);
                        ++this.lineCount$1.elem;
                        if (this.lineCount$1.elem % 1000000 == 0) {
                            QuadReader$.MODULE$.org$dbpedia$extraction$scripts$QuadReader$$logRead(this.tag$1, this.lineCount$1.elem, this.start$1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    }
                }
            }
            {
                this.tag$1 = tag$1;
                this.proc$1 = proc$1;
                this.lineCount$1 = lineCount$1;
                this.start$1 = start$1;
            }
        });
        this.org$dbpedia$extraction$scripts$QuadReader$$logRead(tag, lineCount.elem, start);
    }

    public <T> boolean readQuads$default$3() {
        return false;
    }

    public void org$dbpedia$extraction$scripts$QuadReader$$logRead(String tag, int lines, long start) {
        long micros = (System.nanoTime() - start) / 1000L;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)tag).append((Object)": read ").append((Object)BoxesRunTime.boxToInteger((int)lines)).append((Object)" lines in ").append((Object)StringUtils$.MODULE$.prettyMillis(micros / 1000L)).append((Object)" (").append((Object)BoxesRunTime.boxToFloat((float)((float)micros / (float)lines))).append((Object)" micros per line)").toString());
    }

    private QuadReader$() {
        MODULE$ = this;
    }
}

