/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Writer;
import org.dbpedia.extraction.destinations.DBpediaDatasets$;
import org.dbpedia.extraction.destinations.Dataset;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.Regex;

public final class CreateFreebaseLinks$ {
    public static final CreateFreebaseLinks$ MODULE$;
    private final Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$FreebaseWikipediaId;
    private final Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaResId;
    private final Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$DBpediaResId;
    private final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix;
    private final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix;
    private final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix;

    static {
        new CreateFreebaseLinks$();
    }

    public Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$FreebaseWikipediaId() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$FreebaseWikipediaId;
    }

    public Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaResId() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaResId;
    }

    public Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$DBpediaResId() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$DBpediaResId;
    }

    public String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix;
    }

    public String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix;
    }

    public String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix;
    }

    public void main(String[] args) {
        File dir = new File(args[0]);
        String suffix = args[1];
        File inFile = new File(args[2]);
        File outFile = new File(args[3]);
        Finder finder = new Finder((Object)dir, Language$.MODULE$.English(), "wiki", (Function1)new Serializable(){

            public final RichFile apply(File file) {
                return RichFile$.MODULE$.wrapFile(file);
            }
        });
        String date = (String)finder.dates("download-complete", finder.dates$default$2(), finder.dates$default$3()).last();
        File pageIds = this.find$1(DBpediaDatasets$.MODULE$.PageIds(), suffix, finder, date);
        File redirects = this.find$1(DBpediaDatasets$.MODULE$.Redirects(), suffix, finder, date);
        File disambig = this.find$1(DBpediaDatasets$.MODULE$.DisambiguationLinks(), suffix, finder, date);
        Map dbpediaMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.collectUris((Map<String, String>)dbpediaMap, pageIds, true);
        this.collectUris((Map<String, String>)dbpediaMap, redirects, false);
        this.collectUris((Map<String, String>)dbpediaMap, disambig, false);
        scala.collection.immutable.Map finalDbpediaMap = ((TraversableOnce)dbpediaMap.map((Function1)new Serializable(){

            public final Tuple2<String, String> apply(Tuple2<String, String> x$1) {
                return x$1.swap();
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.findLinks((scala.collection.immutable.Map<String, String>)finalDbpediaMap, inFile, outFile);
    }

    private void collectUris(Map<String, String> map, File file, boolean add) {
        long start = System.nanoTime();
        Console$.MODULE$.err().println(new StringBuilder().append((Object)(add ? "Add" : "Subtract")).append((Object)"ing DBpedia URIs in ").append((Object)file).append((Object)"...").toString());
        IntRef lines = IntRef.create((int)0);
        IOUtils$.MODULE$.readLines((FileLike)RichFile$.MODULE$.wrapFile(file), IOUtils$.MODULE$.readLines$default$2(), (Function1)new Serializable(map, add, start, lines){
            private final Map map$1;
            private final boolean add$1;
            private final long start$1;
            private final IntRef lines$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(String line) {
                MapLike mapLike;
                Tuple2 tuple2;
                Tuple2 tuple22;
                if (!new StringOps(Predef$.MODULE$.augmentString(line)).nonEmpty() || line.charAt(0) == '#') return;
                String string = line;
                Option option = CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaResId().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String rdfKey = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String wikiPageId = (String)((LinearSeqOptimized)option.get()).apply(1);
                    tuple22 = new Tuple2((Object)rdfKey, (Object)wikiPageId);
                } else {
                    Option option2 = CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$DBpediaResId().unapplySeq((CharSequence)string);
                    if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(1) != 0) throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid format for line: ").append((Object)line).toString());
                    String rdfKey = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    tuple22 = new Tuple2((Object)rdfKey, null);
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                String rdfKey = (String)tuple23._1();
                String wikiPageId = (String)tuple23._2();
                Tuple2 tuple24 = tuple2 = new Tuple2((Object)rdfKey, (Object)wikiPageId);
                String rdfKey2 = (String)tuple24._1();
                String wikiPageId2 = (String)tuple24._2();
                if (this.add$1) {
                    if (rdfKey2 == null || wikiPageId2 == null) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"There was a problem with line: ").append((Object)line).toString());
                    }
                    mapLike = this.map$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rdfKey2), (Object)wikiPageId2));
                } else {
                    if (rdfKey2 == null) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"There was a problem with line: ").append((Object)line).toString());
                    }
                    mapLike = this.map$1.$minus$eq((Object)rdfKey2);
                }
                ++this.lines$1.elem;
                if (this.lines$1.elem % 1000000 != 0) return;
                CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(this.lines$1.elem, this.start$1);
            }
            {
                this.map$1 = map$1;
                this.add$1 = add$1;
                this.start$1 = start$1;
                this.lines$1 = lines$1;
            }
        });
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(lines.elem, start);
    }

    public void org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(int lines, long start) {
        long nanos = System.nanoTime() - start;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"processed ").append((Object)BoxesRunTime.boxToInteger((int)lines)).append((Object)" lines in ").append((Object)StringUtils$.MODULE$.prettyMillis(nanos / 1000000L)).append((Object)" (").append((Object)BoxesRunTime.boxToFloat((float)((float)nanos / (float)lines))).append((Object)" nanos per line)").toString());
    }

    /*
     * WARNING - void declaration
     */
    private void findLinks(scala.collection.immutable.Map<String, String> dbpedia, File inFile, File outFile) {
        long start = System.nanoTime();
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"Searching for Freebase links in ").append((Object)inFile).append((Object)"...").toString());
        IntRef lines = IntRef.create((int)0);
        IntRef links = IntRef.create((int)0);
        Writer writer2 = IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(outFile), IOUtils$.MODULE$.writer$default$2());
        try {
            writer2.write(new StringBuilder().append((Object)"# started ").append((Object)StringUtils$.MODULE$.formatCurrentTimestamp()).append((Object)"\n").toString());
            IOUtils$.MODULE$.readLines((FileLike)RichFile$.MODULE$.wrapFile(inFile), IOUtils$.MODULE$.readLines$default$2(), (Function1)new Serializable(dbpedia, start, lines, links, writer2){
                private final scala.collection.immutable.Map dbpedia$1;
                private final long start$2;
                private final IntRef lines$2;
                private final IntRef links$1;
                private final Writer writer$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(String line) {
                    String string = line;
                    Option option = CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$FreebaseWikipediaId().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                        BoxedUnit boxedUnit;
                        String mid = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String wikiId = (String)((LinearSeqOptimized)option.get()).apply(1);
                        if (!mid.startsWith("m.")) throw new IllegalArgumentException(line);
                        if (this.dbpedia$1.contains((Object)wikiId)) {
                            this.writer$1.write(new StringBuilder().append((Object)CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix()).append(this.dbpedia$1.apply((Object)wikiId)).append((Object)CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix()).append((Object)mid).append((Object)CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix()).toString());
                            ++this.links$1.elem;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    ++this.lines$2.elem;
                    if (this.lines$2.elem % 1000000 != 0) return;
                    CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(this.lines$2.elem, this.links$1.elem, this.start$2);
                }
                {
                    this.dbpedia$1 = dbpedia$1;
                    this.start$2 = start$2;
                    this.lines$2 = lines$2;
                    this.links$1 = links$1;
                    this.writer$1 = writer$1;
                }
            });
            writer2.write(new StringBuilder().append((Object)"# completed ").append((Object)StringUtils$.MODULE$.formatCurrentTimestamp()).append((Object)"\n").toString());
        }
        catch (Throwable throwable) {
            void var8_7;
            var8_7.close();
            throw throwable;
        }
        writer2.close();
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(lines.elem, links.elem, start);
    }

    public void org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(int lines, int links, long start) {
        long nanos = System.nanoTime() - start;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"processed ").append((Object)BoxesRunTime.boxToInteger((int)lines)).append((Object)" lines, found ").append((Object)BoxesRunTime.boxToInteger((int)links)).append((Object)" Freebase links in ").append((Object)StringUtils$.MODULE$.prettyMillis(nanos / 1000000L)).append((Object)" (").append((Object)BoxesRunTime.boxToFloat((float)((float)nanos / (float)lines))).append((Object)" nanos per line)").toString());
    }

    /*
     * WARNING - void declaration
     */
    private final File find$1(Dataset dataset, String suffix$1, Finder finder$1, String date$1) {
        void var5_5;
        File file = (File)finder$1.file(date$1, new StringBuilder().append((Object)dataset.name().replace('_', '-')).append((Object)suffix$1).toString());
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(var5_5.toString());
    }

    private CreateFreebaseLinks$() {
        MODULE$ = this;
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$FreebaseWikipediaId = new StringOps(Predef$.MODULE$.augmentString("^<http://rdf\\.freebase\\.com/ns/([^>]+)>\\t<http://rdf\\.freebase\\.com/ns/type\\.object\\.key>\\t\"/wikipedia/en_id/([^\\s]+)\"\\t?\\.$")).r();
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaResId = new StringOps(Predef$.MODULE$.augmentString("^<http://dbpedia\\.org/resource/([^\\s]+)> .* \"(\\d+)\"\\^\\^<http://www\\.w3\\.org/2001/XMLSchema\\#integer> \\.$")).r();
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$DBpediaResId = new StringOps(Predef$.MODULE$.augmentString("^<http://dbpedia\\.org/resource/([^\\s]+)> .*")).r();
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix = "<http://dbpedia.org/resource/";
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix = "> <http://www.w3.org/2002/07/owl#sameAs> <http://rdf.freebase.com/ns/";
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix = "> .\n";
    }
}

