/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.scripts.DateFinder;
import org.dbpedia.extraction.scripts.GenerateListOfExistingAbstracts$;
import org.dbpedia.extraction.scripts.QuadReader$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class GenerateListOfExistingAbstracts$ {
    public static final GenerateListOfExistingAbstracts$ MODULE$;

    static {
        new GenerateListOfExistingAbstracts$();
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 4, (Function0)new Serializable(){

            public final String apply() {
                return "need at least three args: base dir, input suffix (e.g., .nt.gz), output file name (e.g., existing-abtracts.tsv), language code of generic domain (e.g., en), languages or article count ranges (e.g. 'en,fr' or '10000-')";
            }
        });
        File baseDir = new File(args[0]);
        String suffix = args[1];
        File outputFile = new File(args[2]);
        String genericDomain = args[3];
        Language[] languages = ConfigUtils$.MODULE$.parseLanguages(baseDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(4)));
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])languages).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no languages";
            }
        });
        BufferedWriter writer2 = new BufferedWriter(new FileWriter(outputFile));
        writer2.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"language\\tsubject\\n"})).s((Seq)Nil$.MODULE$));
        Predef$.MODULE$.refArrayOps((Object[])languages).foreach((Function1)new Serializable(baseDir, suffix, genericDomain, writer2){
            private final File baseDir$1;
            private final String suffix$1;
            public final String genericDomain$1;
            public final BufferedWriter writer$1;

            public final void apply(Language language) {
                DateFinder<File> finder = new DateFinder<File>(this.baseDir$1, language, (Function1<File, FileLike<File>>)new Serializable(this){

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                QuadReader$.MODULE$.readQuads(finder, new StringBuilder().append((Object)"long-abstracts").append((Object)this.suffix$1).toString(), true, (Function1<Quad, BoxedUnit>)new Serializable(this, language){
                    private final /* synthetic */ anonfun.main.3 $outer;
                    private final Language language$1;

                    public final void apply(Quad quad) {
                        String languageUri = quad.subject().startsWith("http://dbpedia.org") ? quad.subject().replace("http://dbpedia.org", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ".dbpedia.org"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.genericDomain$1}))) : quad.subject();
                        this.$outer.writer$1.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.language$1.wikiCode(), languageUri})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.language$1 = language$1;
                    }
                }, new Serializable(this){

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
            }
            {
                this.baseDir$1 = baseDir$1;
                this.suffix$1 = suffix$1;
                this.genericDomain$1 = genericDomain$1;
                this.writer$1 = writer$1;
            }
        });
        writer2.close();
    }

    private GenerateListOfExistingAbstracts$() {
        MODULE$ = this;
    }
}

