/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.Writer;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.scripts.DateFinder;
import org.dbpedia.extraction.scripts.QuadReader$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.TransitiveClosure;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ResolveTransitiveLinks$ {
    public static final ResolveTransitiveLinks$ MODULE$;

    static {
        new ResolveTransitiveLinks$();
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 5, (Function0)new Serializable(){

            public final String apply() {
                return "need at least five args: base dir, input file part (e.g. 'redirects'), output file part (e.g. 'transitive-redirects'), triples file suffix (e.g. '.nt.gz'), languages or article count ranges (e.g. 'en,fr' or '10000-')";
            }
        });
        File baseDir = new File(args[0]);
        String input = args[1];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(input)).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no input dataset name";
            }
        });
        String output = args[2];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(output)).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no output dataset name";
            }
        });
        String string = output;
        String string2 = input;
        Predef$.MODULE$.require(string != null ? !string.equals(string2) : string2 != null, (Function0)new Serializable(){

            public final String apply() {
                return "output dataset name must different from input dataset name ";
            }
        });
        String suffix = args[3];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(suffix)).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no file suffix";
            }
        });
        Language[] languages = ConfigUtils$.MODULE$.parseLanguages(baseDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(4)));
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])languages).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no languages";
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])languages).foreach((Function1)new Serializable(baseDir, input, output, suffix){
            private final File baseDir$1;
            private final String input$1;
            private final String output$1;
            private final String suffix$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Language language) {
                DateFinder<File> finder = new DateFinder<File>(this.baseDir$1, language, (Function1<File, FileLike<File>>)new Serializable(this){

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                LinkedHashMap map = new LinkedHashMap();
                ObjectRef predicate = ObjectRef.create(null);
                QuadReader$.MODULE$.readQuads(finder, new StringBuilder().append((Object)this.input$1).append((Object)this.suffix$1).toString(), true, (Function1<Quad, BoxedUnit>)new Serializable(this, map, predicate){
                    private final LinkedHashMap map$1;
                    private final ObjectRef predicate$1;

                    public final void apply(Quad quad) {
                        block2: {
                            block3: {
                                block6: {
                                    block5: {
                                        block4: {
                                            if (quad.context() != null) break block2;
                                            if (quad.datatype() != null) break block3;
                                            if ((String)this.predicate$1.elem != null) break block4;
                                            this.predicate$1.elem = quad.predicate();
                                            break block5;
                                        }
                                        String string = (String)this.predicate$1.elem;
                                        String string2 = quad.predicate();
                                        if (string != null ? !string.equals(string2) : string2 != null) break block6;
                                    }
                                    this.map$1.update((Object)quad.subject(), (Object)quad.value());
                                    return;
                                }
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"expected predicate ").append((Object)((String)this.predicate$1.elem)).append((Object)", found ").append((Object)quad.predicate()).append((Object)": ").append((Object)quad).toString());
                            }
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"expected object uri, found object literal: ").append((Object)quad).toString());
                        }
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"expected triple, found quad: ").append((Object)quad).toString());
                    }
                    {
                        this.map$1 = map$1;
                        this.predicate$1 = predicate$1;
                    }
                }, new Serializable(this){

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                Console$.MODULE$.err().println(new StringBuilder().append((Object)"resolving ").append((Object)BoxesRunTime.boxToInteger((int)map.size())).append((Object)" links...").toString());
                scala.collection.mutable.Seq cycles = new TransitiveClosure((Map)map).resolve();
                Console$.MODULE$.err().println(new StringBuilder().append((Object)"found ").append((Object)BoxesRunTime.boxToInteger((int)cycles.size())).append((Object)" cycles:").toString());
                ((IterableLike)cycles.sortBy((Function1)new Serializable(this){

                    public final int apply(Set<String> x$1) {
                        return -x$1.size();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(this){

                    public final void apply(Set<String> cycle) {
                        Console$.MODULE$.err().println(new StringBuilder().append((Object)"length ").append((Object)BoxesRunTime.boxToInteger((int)cycle.size())).append((Object)": [").append((Object)cycle.mkString(" ")).append((Object)"]").toString());
                    }
                });
                File file = finder.find(new StringBuilder().append((Object)this.output$1).append((Object)this.suffix$1).toString(), finder.find$default$2());
                Console$.MODULE$.err().println(new StringBuilder().append((Object)language.wikiCode()).append((Object)": writing ").append((Object)file).append((Object)" ...").toString());
                Writer writer2 = IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(file), IOUtils$.MODULE$.writer$default$2());
                try {
                    map.withFilter((Function1)new Serializable(this){

                        public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                            Tuple2<String, String> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, predicate, writer2){
                        private final ObjectRef predicate$1;
                        private final Writer writer$1;

                        public final void apply(Tuple2<String, String> x$2) {
                            Tuple2<String, String> tuple2 = x$2;
                            if (tuple2 != null) {
                                String subjUri = (String)tuple2._1();
                                String objUri = (String)tuple2._2();
                                this.writer$1.write(new StringBuilder().append((Object)"<").append((Object)subjUri).append((Object)"> <").append((Object)((String)this.predicate$1.elem)).append((Object)"> <").append((Object)objUri).append((Object)"> .\n").toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.predicate$1 = predicate$1;
                            this.writer$1 = writer$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var7_7;
                    var7_7.close();
                    throw throwable;
                }
                writer2.close();
            }
            {
                this.baseDir$1 = baseDir$1;
                this.input$1 = input$1;
                this.output$1 = output$1;
                this.suffix$1 = suffix$1;
            }
        });
    }

    private ResolveTransitiveLinks$() {
        MODULE$ = this;
    }
}

