/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.dbpedia.extraction.destinations.CompositeDestination;
import org.dbpedia.extraction.destinations.Dataset;
import org.dbpedia.extraction.destinations.DatasetDestination;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.WriterDestination;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.ontology.Ontology;
import org.dbpedia.extraction.ontology.OntologyClass;
import org.dbpedia.extraction.ontology.OntologyProperty;
import org.dbpedia.extraction.ontology.io.OntologyReader;
import org.dbpedia.extraction.scripts.QuadReader$;
import org.dbpedia.extraction.scripts.TypeConsistencyCheck$;
import org.dbpedia.extraction.scripts.TypeConsistencyCheck$$anonfun$main$4$;
import org.dbpedia.extraction.scripts.TypeConsistencyCheck$$anonfun$org$dbpedia$extraction$scripts$TypeConsistencyCheck$;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.Breaks$;

public final class TypeConsistencyCheck$ {
    public static final TypeConsistencyCheck$ MODULE$;
    private final Dataset correctDataset;
    private final Dataset disjointRangeDataset;
    private final Dataset untypedRangeDataset;
    private final Dataset nonDisjointRangeDataset;
    private final Dataset disjointDomainDataset;
    private final Dataset untypedDomainDataset;
    private final Dataset nonDisjointDomainDataset;
    private final Seq<Dataset> datasets;
    private final HashMap<String, OntologyProperty> propertyMap;
    private final HashMap<Tuple2<OntologyClass, OntologyClass>, Object> disjoinedClassesMap;

    static {
        new TypeConsistencyCheck$();
    }

    public Dataset correctDataset() {
        return this.correctDataset;
    }

    public Dataset disjointRangeDataset() {
        return this.disjointRangeDataset;
    }

    public Dataset untypedRangeDataset() {
        return this.untypedRangeDataset;
    }

    public Dataset nonDisjointRangeDataset() {
        return this.nonDisjointRangeDataset;
    }

    public Dataset disjointDomainDataset() {
        return this.disjointDomainDataset;
    }

    public Dataset untypedDomainDataset() {
        return this.untypedDomainDataset;
    }

    public Dataset nonDisjointDomainDataset() {
        return this.nonDisjointDomainDataset;
    }

    public Seq<Dataset> datasets() {
        return this.datasets;
    }

    public HashMap<String, OntologyProperty> propertyMap() {
        return this.propertyMap;
    }

    public HashMap<Tuple2<OntologyClass, OntologyClass>, Object> disjoinedClassesMap() {
        return this.disjoinedClassesMap;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void var5_5;
        ObjectRef ontology$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Predef$.MODULE$.require(args != null && args.length == 2, (Function0)new Serializable(){

            public final String apply() {
                return "Two arguments required, extraction config file and extension to work with";
            }
        });
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(args[0])).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "missing required argument: config file name";
            }
        });
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(args[1])).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "missing required argument: suffix e.g. .tql.gz";
            }
        });
        Properties config = ConfigUtils$.MODULE$.loadConfig(args[0], "UTF-8");
        File baseDir = (File)ConfigUtils$.MODULE$.getValue(config, "base-dir", true, (Function1)new Serializable(){

            public final File apply(String x$1) {
                return new File(x$1);
            }
        });
        if (baseDir.exists()) {
            String langConfString = ConfigUtils$.MODULE$.getString(config, "languages", false);
            Language[] languages = ConfigUtils$.MODULE$.parseLanguages(baseDir, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{langConfString})));
            Map formats = UriPolicy$.MODULE$.parseFormats(config, "uri-policy", "format");
            String suffix = args[1];
            String typesDataset = new StringBuilder().append((Object)"instance-types.").append((Object)suffix).toString();
            String mappedTripleDataset = new StringBuilder().append((Object)"mappingbased-objects-uncleaned-unredirected-redirected.").append((Object)suffix).toString();
            HashSet relatedClasses = new HashSet();
            Predef$.MODULE$.refArrayOps((Object[])languages).foreach((Function1)new Serializable(config, baseDir, formats, ontology$lzy, typesDataset, mappedTripleDataset, relatedClasses, bitmap$0){
                public final Properties config$1;
                private final File baseDir$1;
                private final Map formats$1;
                public final ObjectRef ontology$lzy$1;
                private final String typesDataset$1;
                private final String mappedTripleDataset$1;
                public final HashSet relatedClasses$1;
                public final VolatileByteRef bitmap$0$1;

                public final void apply(Language lang) {
                    Finder finder = new Finder((Object)this.baseDir$1, lang, "wiki", (Function1)new Serializable(this){

                        public final RichFile apply(File file) {
                            return RichFile$.MODULE$.wrapFile(file);
                        }
                    });
                    String date = (String)finder.dates(finder.dates$default$1(), finder.dates$default$2(), finder.dates$default$3()).last();
                    Destination destination = TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$createDestination((Finder<File>)finder, date, (Map<String, Formatter>)this.formats$1);
                    HashMap resourceTypes = new HashMap();
                    try {
                        QuadReader$.MODULE$.readQuads(new StringBuilder().append((Object)lang.wikiCode()).append((Object)": Reading types from ").append((Object)this.typesDataset$1).toString(), (FileLike<?>)RichFile$.MODULE$.wrapFile((File)finder.file(date, this.typesDataset$1)), (Function1<Quad, BoxedUnit>)new Serializable(this, resourceTypes, lang){
                            private final /* synthetic */ anonfun.main.4 $outer;
                            private final HashMap resourceTypes$1;
                            private final Language lang$1;

                            public final void apply(Quad quad) {
                                String x$5 = this.lang$1.wikiCode();
                                String x$6 = quad.copy$default$1();
                                String x$7 = quad.copy$default$2();
                                String x$8 = quad.copy$default$3();
                                String x$9 = quad.copy$default$4();
                                String x$10 = quad.copy$default$5();
                                String x$11 = quad.copy$default$7();
                                Quad q = quad.copy(x$6, x$7, x$8, x$9, x$10, x$5, x$11);
                                TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$computeType(quad, (scala.collection.mutable.Map<String, OntologyClass>)this.resourceTypes$1, TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$ontology$1(this.$outer.config$1, this.$outer.ontology$lzy$1, this.$outer.bitmap$0$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.resourceTypes$1 = resourceTypes$1;
                                this.lang$1 = lang$1;
                            }
                        });
                    }
                    catch (Exception exception) {
                        PrintStream printStream = Console$.MODULE$.err();
                        exception.printStackTrace();
                        printStream.println(BoxedUnit.UNIT);
                        throw Breaks$.MODULE$.break();
                    }
                    try {
                        destination.open();
                        QuadReader$.MODULE$.readQuads(new StringBuilder().append((Object)lang.wikiCode()).append((Object)": Reading types from ").append((Object)this.mappedTripleDataset$1).toString(), (FileLike<?>)RichFile$.MODULE$.wrapFile((File)finder.file(date, this.mappedTripleDataset$1)), (Function1<Quad, BoxedUnit>)new Serializable(this, destination, resourceTypes, lang){
                            private final /* synthetic */ anonfun.main.4 $outer;
                            public final Destination destination$1;
                            private final HashMap resourceTypes$1;
                            public final Language lang$1;

                            public final void apply(Quad quad) {
                                Dataset rangeDataset = TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$checkQuadRange$1(quad, (scala.collection.mutable.Map)this.resourceTypes$1, TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$ontology$1(this.$outer.config$1, this.$outer.ontology$lzy$1, this.$outer.bitmap$0$1), this.$outer.relatedClasses$1);
                                Dataset domainDataset = TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$checkQuadDomain$1(quad, (scala.collection.mutable.Map)this.resourceTypes$1, TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$ontology$1(this.$outer.config$1, this.$outer.ontology$lzy$1, this.$outer.bitmap$0$1), this.$outer.relatedClasses$1);
                                List datasetList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rangeDataset.name(), domainDataset.name()})).distinct();
                                List verifiedDatasets = datasetList.size() == 1 && datasetList.contains((Object)TypeConsistencyCheck$.MODULE$.correctDataset().name()) ? datasetList : (List)datasetList.filter((Function1)new Serializable(this){

                                    public final boolean apply(String x$3) {
                                        String string = x$3;
                                        String string2 = TypeConsistencyCheck$.MODULE$.correctDataset().name();
                                        return string != null ? !string.equals(string2) : string2 != null;
                                    }
                                });
                                verifiedDatasets.foreach((Function1)new Serializable(this, quad){
                                    private final /* synthetic */ anonfun$main$4$$anonfun$apply$2 $outer;
                                    private final Quad quad$2;

                                    public final void apply(String d) {
                                        String x$12 = this.$outer.lang$1.wikiCode();
                                        String x$13 = d;
                                        String x$14 = this.quad$2.copy$default$2();
                                        String x$15 = this.quad$2.copy$default$3();
                                        String x$16 = this.quad$2.copy$default$4();
                                        String x$17 = this.quad$2.copy$default$5();
                                        String x$18 = this.quad$2.copy$default$7();
                                        Quad q = this.quad$2.copy(x$13, x$14, x$15, x$16, x$17, x$12, x$18);
                                        this.$outer.destination$1.write((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Quad[]{q})));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.quad$2 = quad$2;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.destination$1 = destination$1;
                                this.resourceTypes$1 = resourceTypes$1;
                                this.lang$1 = lang$1;
                            }
                        });
                        destination.close();
                        return;
                    }
                    catch (Exception exception) {
                        PrintStream printStream = Console$.MODULE$.err();
                        exception.printStackTrace();
                        printStream.println(BoxedUnit.UNIT);
                        throw Breaks$.MODULE$.break();
                    }
                }
                {
                    this.config$1 = config$1;
                    this.baseDir$1 = baseDir$1;
                    this.formats$1 = formats$1;
                    this.ontology$lzy$1 = ontology$lzy$1;
                    this.typesDataset$1 = typesDataset$1;
                    this.mappedTripleDataset$1 = mappedTripleDataset$1;
                    this.relatedClasses$1 = relatedClasses$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"dir ").append((Object)var5_5).append((Object)" does not exist").toString());
    }

    public void org$dbpedia$extraction$scripts$TypeConsistencyCheck$$computeType(Quad quad, scala.collection.mutable.Map<String, OntologyClass> resourceTypes, Ontology ontology) {
        Breaks$.MODULE$.breakable((Function0)new Serializable(quad, resourceTypes, ontology){
            public final Quad quad$1;
            private final scala.collection.mutable.Map resourceTypes$2;
            private final Ontology ontology$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OntologyClass ontoClass;
                Option classOption;
                block8: {
                    block7: {
                        classOption = this.ontology$2.classes().find((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun$org$dbpedia$extraction$scripts$TypeConsistencyCheck$$computeType$1 $outer;

                            public final boolean apply(Tuple2<String, OntologyClass> x) {
                                String string = ((OntologyClass)x._2()).uri();
                                String string2 = this.$outer.quad$1.value();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        ontoClass = null;
                        if (classOption == null) break block7;
                        Option option = classOption;
                        None$ none$ = None$.MODULE$;
                        if (option != null ? !option.equals(none$) : none$ != null) break block8;
                    }
                    throw Breaks$.MODULE$.break();
                }
                ontoClass = (OntologyClass)((Tuple2)classOption.get())._2();
                if (this.resourceTypes$2.contains((Object)this.quad$1.subject())) {
                    if (ontoClass.relatedClasses().contains(this.resourceTypes$2.apply((Object)this.quad$1.subject()))) {
                        this.resourceTypes$2.update((Object)this.quad$1.subject(), (Object)ontoClass);
                    }
                } else {
                    this.resourceTypes$2.update((Object)this.quad$1.subject(), (Object)ontoClass);
                }
            }
            {
                this.quad$1 = quad$1;
                this.resourceTypes$2 = resourceTypes$2;
                this.ontology$2 = ontology$2;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private OntologyProperty getProperty(String uri, Ontology ontology) {
        block3: {
            block2: {
                if (!this.propertyMap().contains((Object)uri)) break block2;
                v0 = (OntologyProperty)this.propertyMap().apply((Object)uri);
                break block3;
            }
            predicateOpt = ontology.properties().find((Function1)new Serializable(uri){
                private final String uri$1;

                public final boolean apply(Tuple2<String, OntologyProperty> x) {
                    String string = ((OntologyProperty)x._2()).uri();
                    String string2 = this.uri$1;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.uri$1 = uri$1;
                }
            });
            if (predicateOpt == null) ** GOTO lbl-1000
            v1 = predicateOpt;
            var5_4 = None$.MODULE$;
            if (!(v1 != null ? v1.equals(var5_4) == false : var5_4 != null)) lbl-1000:
            // 2 sources

            {
                v2 = null;
            } else {
                v2 = (OntologyProperty)((Tuple2)predicateOpt.get())._2();
            }
            predicate = v2;
            this.propertyMap().put((Object)uri, predicate);
            v0 = predicate;
        }
        return v0;
    }

    public Destination org$dbpedia$extraction$scripts$TypeConsistencyCheck$$createDestination(Finder<File> finder, String date, Map<String, Formatter> formats) {
        ArrayBuffer destination = new ArrayBuffer();
        formats.withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, Formatter> check$ifrefutable$1) {
                Tuple2<String, Formatter> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(finder, date, destination){
            public final Finder finder$1;
            public final String date$1;
            private final ArrayBuffer destination$2;

            public final ArrayBuffer<Destination> apply(Tuple2<String, Formatter> x$4) {
                Tuple2<String, Formatter> tuple2 = x$4;
                if (tuple2 != null) {
                    String suffix = (String)tuple2._1();
                    Formatter format = (Formatter)tuple2._2();
                    HashMap datasetDestinations = new HashMap();
                    TypeConsistencyCheck$.MODULE$.datasets().foreach((Function1)new Serializable(this, suffix, format, datasetDestinations){
                        private final /* synthetic */ anonfun$org$dbpedia$extraction$scripts$TypeConsistencyCheck$$createDestination$2 $outer;
                        private final String suffix$1;
                        private final Formatter format$1;
                        private final HashMap datasetDestinations$1;

                        public final void apply(Dataset dataset) {
                            File file = (File)this.$outer.finder$1.file(this.$outer.date$1, new StringBuilder().append((Object)dataset.name().replace('_', '-')).append((Object)BoxesRunTime.boxToCharacter((char)'.')).append((Object)this.suffix$1).toString());
                            this.datasetDestinations$1.update((Object)dataset.name(), (Object)new WriterDestination(TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$writer(file), this.format$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.suffix$1 = suffix$1;
                            this.format$1 = format$1;
                            this.datasetDestinations$1 = datasetDestinations$1;
                        }
                    });
                    ArrayBuffer arrayBuffer = this.destination$2.$plus$eq((Object)new DatasetDestination((Map)datasetDestinations));
                    return arrayBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.finder$1 = finder$1;
                this.date$1 = date$1;
                this.destination$2 = destination$2;
            }
        });
        return new CompositeDestination(destination.toSeq());
    }

    public Function0<Writer> org$dbpedia$extraction$scripts$TypeConsistencyCheck$$writer(File file) {
        return new Serializable(file){
            private final File file$1;

            public final Writer apply() {
                return IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(this.file$1), IOUtils$.MODULE$.writer$default$2());
            }
            {
                this.file$1 = file$1;
            }
        };
    }

    private final Ontology ontology$lzycompute$1(Properties config$1, ObjectRef ontology$lzy$1, VolatileByteRef bitmap$0$1) {
        TypeConsistencyCheck$ typeConsistencyCheck$ = this;
        synchronized (typeConsistencyCheck$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                Source source;
                File ontologyFile = (File)ConfigUtils$.MODULE$.getValue(config$1, "ontology", false, (Function1)new Serializable(){

                    public final File apply(String x$2) {
                        return new File(x$2);
                    }
                });
                if (ontologyFile != null && ontologyFile.isFile()) {
                    source = XMLSource$.MODULE$.fromFile(ontologyFile, Language$.MODULE$.Mappings(), XMLSource$.MODULE$.fromFile$default$3());
                } else {
                    Set namespaces = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.OntologyClass(), Namespace$.MODULE$.OntologyProperty()}));
                    URL url = new URL(Language$.MODULE$.Mappings().apiUri());
                    source = WikiSource$.MODULE$.fromNamespaces(namespaces, url, Language$.MODULE$.Mappings());
                }
                Source ontologySource = source;
                ontology$lzy$1.elem = new OntologyReader().read(ontologySource);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Ontology)ontology$lzy$1.elem;
        }
    }

    public final Ontology org$dbpedia$extraction$scripts$TypeConsistencyCheck$$ontology$1(Properties config$1, ObjectRef ontology$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.ontology$lzycompute$1(config$1, ontology$lzy$1, bitmap$0$1) : (Ontology)ontology$lzy$1.elem;
    }

    public final Dataset org$dbpedia$extraction$scripts$TypeConsistencyCheck$$checkQuadRange$1(Quad quad, scala.collection.mutable.Map resourceTypes, Ontology ontology, HashSet relatedClasses$1) {
        block10: {
            OntologyProperty predicate;
            OntologyClass obj;
            block11: {
                block9: {
                    None$ none$;
                    OntologyClass ontologyClass;
                    if (quad.datatype() != null) break block10;
                    try {
                        obj = (OntologyClass)resourceTypes.apply((Object)quad.value());
                        predicate = this.getProperty(quad.predicate(), ontology);
                        if (predicate != null && predicate.range().uri().trim().equals("http://www.w3.org/2002/07/owl#Thing")) {
                            return this.correctDataset();
                        }
                        if (obj == null) break block9;
                        ontologyClass = obj;
                        none$ = None$.MODULE$;
                    }
                    catch (Throwable throwable) {
                        return this.untypedRangeDataset();
                    }
                    if (ontologyClass != null ? !ontologyClass.equals(none$) : none$ != null) break block11;
                }
                return this.untypedRangeDataset();
            }
            if (predicate == null) {
                return null;
            }
            if (obj.relatedClasses().contains((Object)predicate.range())) {
                return this.correctDataset();
            }
            if (this.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$isDisjoined$1(obj, (OntologyClass)predicate.range(), true, relatedClasses$1)) {
                return this.disjointRangeDataset();
            }
            return this.nonDisjointRangeDataset();
        }
        return this.correctDataset();
    }

    public final Dataset org$dbpedia$extraction$scripts$TypeConsistencyCheck$$checkQuadDomain$1(Quad quad, scala.collection.mutable.Map resourceTypes, Ontology ontology, HashSet relatedClasses$1) {
        OntologyProperty predicate;
        OntologyClass subj;
        block10: {
            block9: {
                None$ none$;
                OntologyClass ontologyClass;
                try {
                    subj = (OntologyClass)resourceTypes.apply((Object)quad.subject());
                    predicate = this.getProperty(quad.predicate(), ontology);
                    if (predicate != null && predicate.domain().uri().trim().equals("http://www.w3.org/2002/07/owl#Thing")) {
                        return this.correctDataset();
                    }
                    if (subj == null) break block9;
                    ontologyClass = subj;
                    none$ = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    return this.untypedDomainDataset();
                }
                if (ontologyClass != null ? !ontologyClass.equals(none$) : none$ != null) break block10;
            }
            return this.untypedDomainDataset();
        }
        if (predicate == null) {
            return null;
        }
        if (subj.relatedClasses().contains((Object)predicate.domain())) {
            return this.correctDataset();
        }
        if (this.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$isDisjoined$1(subj, predicate.domain(), true, relatedClasses$1)) {
            return this.disjointDomainDataset();
        }
        return this.nonDisjointDomainDataset();
    }

    public final boolean org$dbpedia$extraction$scripts$TypeConsistencyCheck$$isDisjoined$1(OntologyClass objClass, OntologyClass rangeClass, boolean clear, HashSet relatedClasses$1) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            boolean bl;
            Object object = new Object();
            try {
                if (clear) {
                    relatedClasses$1.clear();
                }
                if (this.disjoinedClassesMap().keySet().contains((Object)new Tuple2((Object)objClass, (Object)rangeClass)) && BoxesRunTime.unboxToBoolean((Object)this.disjoinedClassesMap().apply((Object)new Tuple2((Object)objClass, (Object)rangeClass)))) {
                    return true;
                }
                if (objClass.disjointWithClasses().contains((Object)rangeClass) || rangeClass.disjointWithClasses().contains((Object)objClass)) {
                    this.disjoinedClassesMap().put((Object)new Tuple2((Object)objClass, (Object)rangeClass), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    this.disjoinedClassesMap().put((Object)new Tuple2((Object)rangeClass, (Object)objClass), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return true;
                }
                relatedClasses$1.add((Object)new Tuple2((Object)objClass, (Object)rangeClass));
                relatedClasses$1.add((Object)new Tuple2((Object)rangeClass, (Object)objClass));
                objClass.relatedClasses().foreach((Function1)new Serializable(relatedClasses$1, rangeClass, object){
                    public final HashSet relatedClasses$1;
                    private final OntologyClass rangeClass$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(OntologyClass objClazz) {
                        this.rangeClass$1.relatedClasses().foreach((Function1)new Serializable(this, objClazz){
                            private final /* synthetic */ anonfun$org$dbpedia$extraction$scripts$TypeConsistencyCheck$$isDisjoined$1$1 $outer;
                            private final OntologyClass objClazz$1;

                            public final void apply(OntologyClass rangeClazz) {
                                if (!this.$outer.relatedClasses$1.contains((Object)new Tuple2((Object)this.objClazz$1, (Object)rangeClazz)) && TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$isDisjoined$1(this.objClazz$1, rangeClazz, false, this.$outer.relatedClasses$1)) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                                }
                                if (!this.$outer.relatedClasses$1.contains((Object)new Tuple2((Object)rangeClazz, (Object)this.objClazz$1)) && TypeConsistencyCheck$.MODULE$.org$dbpedia$extraction$scripts$TypeConsistencyCheck$$isDisjoined$1(rangeClazz, this.objClazz$1, false, this.$outer.relatedClasses$1)) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.objClazz$1 = objClazz$1;
                            }
                        });
                    }
                    {
                        this.relatedClasses$1 = relatedClasses$1;
                        this.rangeClass$1 = rangeClass$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    private final boolean isDisjoined$default$3$1() {
        return true;
    }

    private TypeConsistencyCheck$() {
        MODULE$ = this;
        this.correctDataset = new Dataset("mappingbased-objects");
        this.disjointRangeDataset = new Dataset("mappingbased-objects-disjoint-range");
        this.untypedRangeDataset = this.correctDataset();
        this.nonDisjointRangeDataset = this.correctDataset();
        this.disjointDomainDataset = new Dataset("mappingbased-objects-disjoint-domain");
        this.untypedDomainDataset = this.correctDataset();
        this.nonDisjointDomainDataset = this.correctDataset();
        this.datasets = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.correctDataset(), this.disjointRangeDataset(), this.disjointDomainDataset()}));
        this.propertyMap = new HashMap();
        this.disjoinedClassesMap = new HashMap();
    }
}

