/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.Writer;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.scripts.DateFinder;
import org.dbpedia.extraction.scripts.QuadReader$;
import org.dbpedia.extraction.scripts.UnmodifiedFeederCacheGenerator$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UnmodifiedFeederCacheGenerator$ {
    public static final UnmodifiedFeederCacheGenerator$ MODULE$;

    static {
        new UnmodifiedFeederCacheGenerator$();
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 4, (Function0)new Serializable(){

            public final String apply() {
                return "need at least four args: base dir, mapping file suffix (e.g. '.nt.gz', '.ttl', '.ttl.bz2'), timestamp to use for cache (e.g. '2013-02-27', 'now()' ), languages (e.g. 'en,fr')";
            }
        });
        File baseDir = new File(args[0]);
        String suffix = args[1];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(suffix)).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no mapping file suffix";
            }
        });
        String timestamp = args[2];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(timestamp)).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no timestamp";
            }
        });
        Language[] languages = ConfigUtils$.MODULE$.parseLanguages(baseDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(3)));
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])languages).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "no languages";
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])languages).foreach((Function1)new Serializable(baseDir, suffix, timestamp){
            private final File baseDir$1;
            private final String suffix$1;
            public final String timestamp$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Language language) {
                DateFinder<File> finder = new DateFinder<File>(this.baseDir$1, language, (Function1<File, FileLike<File>>)new Serializable(this){

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                Writer writer2 = IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(new File(new StringBuilder().append((Object)language.wikiCode()).append((Object)"-cache_generate.sql").toString())), IOUtils$.MODULE$.writer$default$2());
                try {
                    QuadReader$.MODULE$.readQuads(finder, new StringBuilder().append((Object)"page-ids").append((Object)this.suffix$1).toString(), true, (Function1<Quad, BoxedUnit>)new Serializable(this, writer2){
                        private final /* synthetic */ anonfun.main.5 $outer;
                        private final Writer writer$1;

                        public final void apply(Quad quad) {
                            int pageID = new StringOps(Predef$.MODULE$.augmentString(quad.value())).toInt();
                            if (pageID > 0) {
                                this.writer$1.write(new StringBuilder().append((Object)"INSERT INTO  DBPEDIALIVE_CACHE(pageID, updated) VALUES(").append((Object)BoxesRunTime.boxToInteger((int)pageID)).append((Object)", '").append((Object)this.$outer.timestamp$1).append((Object)"') ; \n").toString());
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.writer$1 = writer$1;
                        }
                    }, new Serializable(this){

                        public final RichFile apply(File file) {
                            return RichFile$.MODULE$.wrapFile(file);
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var3_3;
                    var3_3.close();
                    throw throwable;
                }
                writer2.close();
            }
            {
                this.baseDir$1 = baseDir$1;
                this.suffix$1 = suffix$1;
                this.timestamp$1 = timestamp$1;
            }
        });
    }

    private UnmodifiedFeederCacheGenerator$() {
        MODULE$ = this;
    }
}

