/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.util.ArrayList;
import java.util.List;
import org.dbrain.data.Fqns;

public class Fqn {
    private final List<String> segments;

    public Fqn(List<String> segments) {
        this.segments = segments != null && segments.size() > 0 ? new ArrayList<String>(segments) : null;
    }

    public int getSize() {
        return this.segments != null ? this.segments.size() : 0;
    }

    public String getSegment(int i) {
        if (this.segments != null) {
            return this.segments.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        if (this.segments == null || this.segments.size() == 0) {
            return "";
        }
        if (this.segments.size() == 1) {
            return Fqns.encodeSegment(this.segments.get(0));
        }
        StringBuilder sb = null;
        for (String s : this.segments) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(".");
            }
            sb.append(Fqns.encodeSegment(s));
        }
        return sb.toString();
    }
}

