/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dbrain.data.Lookup;

public class Lookups {
    public static <FROM, TO> LookupBuilder<FROM, TO> map(FROM fromValue, TO toValue) {
        LookupBuilder<FROM, TO> result = new LookupBuilder<FROM, TO>();
        return result.map(fromValue, toValue);
    }

    public static <FROM, TO> Lookup<TO, FROM> inverse(Lookup<FROM, TO> lookup) {
        LookupBuilder result = new LookupBuilder().preventNullMapping();
        for (FROM fromValue : lookup.keySet()) {
            Object toValue = lookup.apply(fromValue);
            result.map(toValue, fromValue);
        }
        return result.build();
    }

    public static class LookupBuilder<FROM, TO> {
        private boolean defaultNullMapping = true;
        private Map<FROM, TO> map = new HashMap<FROM, TO>();

        public LookupBuilder<FROM, TO> map(FROM fromValue, TO toValue) {
            if (this.map.containsKey(fromValue)) {
                throw new IllegalArgumentException();
            }
            if (fromValue == null) {
                this.defaultNullMapping = false;
            }
            this.map.put(fromValue, toValue);
            return this;
        }

        public LookupBuilder<FROM, TO> preventNullMapping() {
            this.defaultNullMapping = false;
            return this;
        }

        public Lookup<FROM, TO> build() {
            try {
                if (this.defaultNullMapping) {
                    this.map.put(null, null);
                }
                LookupImpl lookupImpl = new LookupImpl(this.map);
                return lookupImpl;
            }
            finally {
                this.map = null;
            }
        }

        private static class LookupImpl<FROM, TO>
        implements Lookup<FROM, TO>,
        Serializable {
            private final Set<FROM> possibleValues;
            private final Map<FROM, TO> map;

            private LookupImpl(Map<FROM, TO> map) {
                this.map = map;
                this.possibleValues = Collections.unmodifiableSet(map.keySet());
            }

            @Override
            public Set<FROM> keySet() {
                return this.possibleValues;
            }

            @Override
            public TO apply(FROM from) {
                if (this.map.containsKey(from)) {
                    return this.map.get(from);
                }
                throw new IllegalArgumentException();
            }
        }
    }
}

