/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.csv;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbrain.data.ForwardCursor;
import org.dbrain.data.parsing.ReaderCursor;
import org.dbrain.data.text.ParseException;

public class CsvCursor
implements ForwardCursor,
AutoCloseable {
    private int separator;
    private int quote;
    private ReaderCursor cursor;
    private Map<String, Integer> fieldsMap;
    private List<String> fieldValues;
    private boolean bof = true;

    private boolean isEOF(int c) {
        return c < 0;
    }

    private boolean isEOL(int c) {
        return c == 13 || c == 10 || this.isEOF(c);
    }

    private boolean isEOC(int c) {
        return c == this.separator || this.isEOL(c);
    }

    private boolean isSpace(int c) {
        return c <= 32 && !this.isEOL(c);
    }

    private String readSpace() {
        StringBuilder sb = new StringBuilder();
        int cur = this.cursor.current();
        while (this.isSpace(cur)) {
            sb.appendCodePoint(cur);
            cur = this.cursor.next();
        }
        return sb.toString();
    }

    private String readQuotedString() {
        if (this.cursor.current() != this.quote) {
            throw new ParseException("Invalid quoted string.");
        }
        this.cursor.consume();
        StringBuilder sb = new StringBuilder();
        int cur = this.cursor.current();
        while (!(this.isEOL(cur) || cur == this.quote && (cur = this.cursor.next()) != this.quote)) {
            sb.appendCodePoint(cur);
            cur = this.cursor.next();
        }
        return sb.toString();
    }

    private String readUnquotedString() {
        StringBuilder sb = new StringBuilder();
        int cur = this.cursor.current();
        while (!this.isEOC(cur)) {
            sb.append((char)cur);
            cur = this.cursor.next();
        }
        return sb.toString();
    }

    private String readString() {
        String spaces = this.readSpace();
        return this.cursor.current() == this.quote ? this.readQuotedString() : spaces + this.readUnquotedString();
    }

    private List<String> readLine() {
        ArrayList<String> result = new ArrayList<String>();
        while (!this.isEOL(this.cursor.current())) {
            result.add(this.readString());
            if (!this.isEOC(this.cursor.current()) || this.isEOL(this.cursor.current())) continue;
            this.cursor.consume();
        }
        int cur = this.cursor.current();
        while (this.isEOL(cur) && !this.isEOF(cur)) {
            cur = this.cursor.next();
        }
        return result;
    }

    private void setFieldNames(String[] fieldNames) {
        this.fieldsMap = new HashMap<String, Integer>(fieldNames.length);
        int i = 0;
        for (String name : fieldNames) {
            this.fieldsMap.put(name.trim(), i);
            ++i;
        }
    }

    public CsvCursor(Reader reader, int separator, int stringQuote, String[] fieldNames) {
        this.cursor = new ReaderCursor(reader);
        this.separator = separator;
        this.quote = stringQuote;
        this.setFieldNames(fieldNames);
    }

    public CsvCursor(Reader reader, int separator, int stringQuote) {
        this.cursor = new ReaderCursor(reader);
        this.separator = separator;
        this.quote = stringQuote;
        List<String> fieldNames = this.readLine();
        this.setFieldNames(fieldNames.toArray(new String[fieldNames.size()]));
    }

    public CsvCursor(Reader reader, int separator) {
        this(reader, separator, -1);
    }

    @Override
    public boolean eof() {
        return this.bof ? this.next() : this.fieldValues == null;
    }

    @Override
    public boolean next() {
        if (this.bof) {
            this.bof = false;
        }
        this.fieldValues = this.isEOF(this.cursor.current()) ? null : this.readLine();
        return this.fieldValues != null;
    }

    @Override
    public Object get(int index) {
        if (this.fieldValues == null) {
            throw new IllegalStateException();
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return index < this.fieldValues.size() ? this.fieldValues.get(index) : null;
    }

    @Override
    public Object get(String name) {
        if (this.fieldValues == null) {
            throw new IllegalStateException();
        }
        if (this.fieldsMap == null) {
            throw new IllegalArgumentException();
        }
        Integer idx = this.fieldsMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException();
        }
        return idx < this.fieldValues.size() ? this.fieldValues.get(idx) : null;
    }

    @Override
    public void close() throws Exception {
        if (this.cursor == null) {
            throw new IllegalStateException();
        }
        this.cursor.close();
        this.cursor = null;
    }
}

