/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.json;

import java.io.Reader;
import org.dbrain.data.parsing.ReaderCursor;
import org.dbrain.data.text.ParseException;

public class JsonParser {
    private ReaderCursor cursor;
    private boolean parsed = false;
    private Token token;
    private Object value;

    public JsonParser(Reader r) {
        this.cursor = new ReaderCursor(r);
    }

    public ParseException error(String message) {
        return this.cursor.error(message);
    }

    private void skipWhiteSpace() {
        int current = this.cursor.current();
        while (current >= 0 && current <= 32 || Character.isWhitespace(current)) {
            current = this.cursor.next();
        }
    }

    private void setToken(Token token, Object value) {
        this.parsed = true;
        this.token = token;
        this.value = value;
    }

    private void setToken(Token token) {
        this.setToken(token, null);
    }

    private String parseString() {
        int quote = this.cursor.current();
        StringBuilder sb = new StringBuilder();
        int codePoint = this.cursor.next();
        while (codePoint != quote) {
            block13: {
                block12: {
                    if (codePoint < 0 || codePoint == 13 || codePoint == 10) {
                        throw this.cursor.error("Unterminated string");
                    }
                    if (codePoint != 92) break block12;
                    codePoint = this.cursor.next();
                    switch (codePoint) {
                        case 98: {
                            sb.append('\b');
                            break block13;
                        }
                        case 116: {
                            sb.append('\t');
                            break block13;
                        }
                        case 110: {
                            sb.append('\n');
                            break block13;
                        }
                        case 102: {
                            sb.append('\f');
                            break block13;
                        }
                        case 114: {
                            sb.append('\r');
                            break block13;
                        }
                        case 117: {
                            sb.append((char)Integer.parseInt(this.cursor.next(4), 16));
                            break block13;
                        }
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.appendCodePoint(codePoint);
                            break block13;
                        }
                        default: {
                            throw this.cursor.error("Invalid escape in string");
                        }
                    }
                }
                if (codePoint < 32) {
                    throw this.cursor.error("Illegal character in string");
                }
                sb.appendCodePoint(codePoint);
            }
            codePoint = this.cursor.next();
        }
        this.cursor.consume();
        return sb.toString();
    }

    private Double parseNumber() {
        StringBuilder sb = new StringBuilder();
        int current = this.cursor.current();
        if (current == 45) {
            sb.appendCodePoint(current);
            current = this.cursor.next();
        }
        while (current >= 48 && current <= 57) {
            sb.appendCodePoint(current);
            current = this.cursor.next();
        }
        if (current == 46) {
            sb.append('.');
            current = this.cursor.next();
            while (current >= 48 && current <= 57) {
                sb.appendCodePoint(current);
                current = this.cursor.next();
            }
        }
        if (current == 101 || current == 69) {
            sb.appendCodePoint(current);
            current = this.cursor.next();
            if (current == 43 || current == 45) {
                sb.appendCodePoint(current);
                current = this.cursor.next();
            }
            while (current >= 48 && current <= 57) {
                sb.appendCodePoint(current);
                current = this.cursor.next();
            }
        }
        if (Character.isJavaIdentifierStart(current)) {
            throw this.cursor.error("Illegal number expression");
        }
        return Double.parseDouble(sb.toString());
    }

    private String parseIdentifier() {
        StringBuilder sb = new StringBuilder();
        sb.appendCodePoint(this.cursor.current());
        int codePoint = this.cursor.next();
        while (Character.isJavaIdentifierPart(codePoint)) {
            sb.appendCodePoint(codePoint);
            codePoint = this.cursor.next();
        }
        return sb.toString();
    }

    public Token getToken() {
        if (!this.parsed) {
            this.skipWhiteSpace();
            int current = this.cursor.current();
            if (current < 0) {
                this.setToken(null);
            } else if (current == 123) {
                this.cursor.consume();
                this.setToken(Token.OPEN_OBJECT);
            } else if (current == 125) {
                this.cursor.consume();
                this.setToken(Token.CLOSE_OBJECT);
            } else if (current == 91) {
                this.cursor.consume();
                this.setToken(Token.OPEN_ARRAY);
            } else if (current == 93) {
                this.cursor.consume();
                this.setToken(Token.CLOSE_ARRAY);
            } else if (current == 44) {
                this.cursor.consume();
                this.setToken(Token.COMMA);
            } else if (current == 58) {
                this.cursor.consume();
                this.setToken(Token.COLON);
            } else if (current == 34 || current == 39) {
                this.setToken(Token.STRING, this.parseString());
            } else if (current >= 48 && current <= 57 || current == 45) {
                this.setToken(Token.DOUBLE, this.parseNumber());
            } else if (Character.isJavaIdentifierStart(current)) {
                String s = this.parseIdentifier();
                if ("true".equalsIgnoreCase(s)) {
                    this.setToken(Token.BOOLEAN, Boolean.TRUE);
                } else if ("false".equalsIgnoreCase(s)) {
                    this.setToken(Token.BOOLEAN, Boolean.FALSE);
                } else if ("null".equalsIgnoreCase(s)) {
                    this.setToken(Token.NULL);
                } else {
                    this.setToken(Token.STRING, s);
                }
            } else {
                throw this.cursor.error("Illegal input");
            }
        }
        return this.token;
    }

    public void skip() {
        this.parsed = false;
    }

    public Token readToken(Token token) {
        if (this.getToken() == token) {
            this.skip();
            return token;
        }
        throw new IllegalStateException();
    }

    public String readString() {
        if (this.getToken() != Token.STRING) {
            throw new IllegalStateException();
        }
        String result = (String)this.value;
        this.skip();
        return result;
    }

    public Double readDouble() {
        if (this.getToken() != Token.DOUBLE) {
            throw new IllegalStateException();
        }
        Double result = (Double)this.value;
        this.skip();
        return result;
    }

    public Boolean readBoolean() {
        if (this.getToken() != Token.BOOLEAN) {
            throw new IllegalStateException();
        }
        Boolean result = (Boolean)this.value;
        this.skip();
        return result;
    }

    public static enum Token {
        OPEN_OBJECT,
        CLOSE_OBJECT,
        OPEN_ARRAY,
        CLOSE_ARRAY,
        COLON,
        COMMA,
        STRING,
        DOUBLE,
        BOOLEAN,
        NULL;

    }
}

