/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.parsing;

import java.io.IOException;
import java.io.InputStream;
import org.dbrain.data.text.ParseException;

public class InputStreamCursor
implements AutoCloseable {
    private static final String ERR_IO_ERROR = "IO exception";
    private InputStream inputStream;
    private int current = -1;
    private int index = 1;
    private int line = 1;
    private int column = 1;
    private boolean consumed = true;

    public InputStreamCursor(InputStream is) {
        this.inputStream = is;
    }

    private void load() {
        try {
            if (this.consumed) {
                this.current = this.inputStream.read();
                ++this.index;
                if (this.current >= 0) {
                    if (this.current == 10) {
                        ++this.line;
                        this.column = 1;
                    } else if (this.current == 9) {
                        this.column += 4;
                    } else if (this.current >= 32) {
                        ++this.column;
                    }
                }
                this.consumed = false;
            }
        }
        catch (IOException ie) {
            throw this.error(ERR_IO_ERROR, ie);
        }
    }

    public ParseException error(String message, Throwable e) {
        return new ParseException(String.format("%s at %s.", message, this.position()), e);
    }

    public ParseException error(String message) {
        return this.error(message, null);
    }

    private String position() {
        return String.format("position %d [%d:%d]", this.index, this.line, this.column);
    }

    public int current() {
        this.load();
        return this.current;
    }

    public int next() {
        this.consume();
        return this.current();
    }

    public void consume() {
        this.consumed = true;
    }

    @Override
    public void close() throws Exception {
        this.inputStream.close();
    }
}

