/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.parsing;

import java.io.Reader;
import org.dbrain.data.parsing.CursorStatus;
import org.dbrain.data.parsing.ReaderCursor;

public class LineCursor {
    private long lineNumber = 0L;
    private CursorStatus status = CursorStatus.BOF;
    private ReaderCursor cursor;
    private String currentLine;

    public LineCursor(Reader r) {
        this.cursor = new ReaderCursor(r);
    }

    private void load() {
        if (this.currentLine == null && this.status == null) {
            int current = this.cursor.current();
            if (current >= 0) {
                StringBuilder sb = new StringBuilder();
                while (current >= 0 && current != 13 && current != 10) {
                    sb.append((char)current);
                    current = this.cursor.next();
                }
                if (current == 13 && this.cursor.next() == 10) {
                    this.cursor.consume();
                }
                if (current == 10 && this.cursor.next() == 13) {
                    this.cursor.consume();
                }
                this.currentLine = sb.toString();
                this.status = CursorStatus.LOADED;
                ++this.lineNumber;
            } else {
                this.status = CursorStatus.EOF;
            }
        }
    }

    private void unload() {
        if (this.status != CursorStatus.EOF) {
            this.status = null;
            this.currentLine = null;
        }
    }

    public CursorStatus getStatus() {
        this.load();
        return this.status;
    }

    public String getCurrent() {
        this.load();
        return this.currentLine;
    }

    public boolean next() {
        this.unload();
        return this.getStatus() == CursorStatus.LOADED;
    }

    public String getNext() {
        this.next();
        return this.getCurrent();
    }
}

