/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.parsing;

import java.io.IOException;
import java.io.Reader;
import org.dbrain.data.text.ParseException;

public class ReaderCursor
implements AutoCloseable {
    private static final String ERR_IO_ERROR = "IO exception";
    private static final String ERR_SURROGATE_ENCODING = "Surrogate encoding error";
    private Reader reader;
    private int current = -1;
    private int index = 1;
    private int line = 1;
    private int column = 1;
    private boolean consumed = true;

    public ReaderCursor(Reader r) {
        this.reader = r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void load() {
        try {
            if (!this.consumed) return;
            this.current = this.reader.read();
            ++this.index;
            if (this.current >= 0) {
                char highSurrogate = (char)this.current;
                if (Character.isHighSurrogate(highSurrogate)) {
                    int next = this.reader.read();
                    ++this.index;
                    if (next < 0) throw this.error(ERR_SURROGATE_ENCODING, null);
                    char lowSurrogate = (char)next;
                    if (!Character.isSurrogatePair(highSurrogate, lowSurrogate)) throw this.error(ERR_SURROGATE_ENCODING, null);
                    this.current = Character.toCodePoint(highSurrogate, lowSurrogate);
                }
                if (this.current == 10) {
                    ++this.line;
                    this.column = 1;
                } else if (this.current == 9) {
                    this.column += 4;
                } else if (this.current >= 32) {
                    ++this.column;
                }
            }
            this.consumed = false;
            return;
        }
        catch (IOException ie) {
            throw this.error(ERR_IO_ERROR, ie);
        }
    }

    public ParseException error(String message, Throwable e) {
        return new ParseException(String.format("%s at %s.", message, this.position()), e);
    }

    public ParseException error(String message) {
        return this.error(message, null);
    }

    private String position() {
        return String.format("position %d [%d:%d]", this.index, this.line, this.column);
    }

    public int current() {
        this.load();
        return this.current;
    }

    public int next() {
        this.consume();
        return this.current();
    }

    public String next(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(count);
        int c = this.next();
        for (int i = 0; i < count && c >= 0; ++i) {
            sb.appendCodePoint(c);
            c = this.next();
        }
        return sb.toString();
    }

    public void consume() {
        this.consumed = true;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

