/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.text;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import org.dbrain.data.Casts;
import org.dbrain.data.text.Format;
import org.dbrain.data.text.FormatException;
import org.dbrain.data.text.ParseException;
import org.dbrain.data.util.Strings;

public class LocalDateFormat
implements Format<LocalDate> {
    private final SimpleDateFormat dateFormat;

    public LocalDateFormat(String pattern, Locale locale) {
        this.dateFormat = new SimpleDateFormat(pattern, locale);
        this.dateFormat.setLenient(false);
    }

    @Override
    public synchronized String format(LocalDate value) throws FormatException {
        return value != null ? this.dateFormat.format(Date.from(value.atStartOfDay(ZoneId.systemDefault()).toInstant())) : null;
    }

    @Override
    public synchronized LocalDate parse(String value) throws ParseException {
        if (Strings.isBlank(value)) {
            return null;
        }
        String trimmedValue = value.trim();
        ParsePosition pos = new ParsePosition(0);
        Date result = this.dateFormat.parse(trimmedValue, pos);
        if (pos.getIndex() != trimmedValue.length()) {
            int index = pos.getErrorIndex() >= 0 ? pos.getErrorIndex() : pos.getIndex();
            throw new ParseException("Error parsing date [" + trimmedValue + "] at position " + index + ".");
        }
        return Casts.toLocalDate(result);
    }
}

