/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public final class Fqn {
    private static final String RESERVED_CHARS = "*'\"?!@#%&()[]{}.,;+-/\\^ ";
    private final List<String> segments;

    public static Fqn of(ReaderCursor c) {
        if (Fqn.isFqnStart(c.peek())) {
            ArrayList<String> segments = new ArrayList<String>();
            segments.add(Fqn.readSegment(c));
            while (c.peek() == 46) {
                c.read();
                segments.add(Fqn.readSegment(c));
            }
            return new Fqn(segments);
        }
        return null;
    }

    public static Fqn of(String fqn) {
        if (fqn == null) {
            return null;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        while (ParserUtils.isSpace(c.peek())) {
            c.read();
        }
        Fqn result = Fqn.of(c);
        while (ParserUtils.isSpace(c.peek())) {
            c.read();
        }
        if (c.peek() >= 0) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    private static boolean isReserved(int cur) {
        return RESERVED_CHARS.indexOf(cur) >= 0;
    }

    private static boolean isQuote(int cur) {
        return cur == 39;
    }

    private static boolean isFqnStart(int cur) {
        return cur >= 0 && (Fqn.isQuote(cur) || !Fqn.isReserved(cur));
    }

    private static boolean isUnquotedSegment(int cur) {
        return cur >= 0 && !Fqn.isReserved(cur);
    }

    private static String readQuotedSegment(ReaderCursor c) {
        int quote = c.read();
        StringBuilder sb = new StringBuilder();
        while (true) {
            int current;
            if ((current = c.read()) == quote) {
                if (c.peek() != quote) break;
                sb.appendCodePoint(c.read());
                continue;
            }
            if (current < 0) {
                throw c.error("Unexpected eof");
            }
            sb.appendCodePoint(current);
        }
        return sb.toString();
    }

    private static String readUnquotedSegment(ReaderCursor cursor) {
        StringBuilder sb = new StringBuilder();
        while (Fqn.isUnquotedSegment(cursor.peek())) {
            sb.appendCodePoint(cursor.read());
        }
        return sb.toString();
    }

    private static String readSegment(ReaderCursor c) {
        if (Fqn.isQuote(c.peek())) {
            return Fqn.readQuotedSegment(c);
        }
        return Fqn.readUnquotedSegment(c);
    }

    private static String encodeSegment(String segment) {
        if (segment.length() == 0) {
            return "''";
        }
        StringBuilder sb = null;
        for (int i = 0; i < segment.length(); ++i) {
            Character c = Character.valueOf(segment.charAt(i));
            if (RESERVED_CHARS.indexOf(c.charValue()) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder(segment.length() + 12);
                    sb.append("'");
                    sb.append(segment.substring(0, i));
                }
                if (c.charValue() == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            sb.append("'");
            return sb.toString();
        }
        return segment;
    }

    private Fqn(List<String> segments) {
        this.segments = segments != null && segments.size() > 0 ? new ArrayList<String>(segments) : null;
    }

    public int size() {
        return this.segments != null ? this.segments.size() : 0;
    }

    public String segment(int i) {
        if (this.segments != null) {
            return this.segments.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fqn fqn = (Fqn)o;
        return this.segments.equals(fqn.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        if (this.segments == null || this.segments.size() == 0) {
            return "";
        }
        if (this.segments.size() == 1) {
            return Fqn.encodeSegment(this.segments.get(0));
        }
        StringBuilder sb = null;
        for (String s : this.segments) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(".");
            }
            sb.append(Fqn.encodeSegment(s));
        }
        return sb.toString();
    }
}

