/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.json;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.dbrain.data.json.JsonList;
import org.dbrain.data.json.JsonValue;

public class JsonMap
extends JsonValue
implements Map<String, JsonValue> {
    private final HashMap<String, JsonValue> delegate;

    JsonMap(HashMap<String, JsonValue> delegate) {
        this.delegate = delegate;
    }

    public JsonMap() {
        this(new HashMap<String, JsonValue>());
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonMap asMap() {
        return this;
    }

    @Override
    public JsonList asList() {
        throw new UnsupportedOperationException();
    }

    public String getString(String name) {
        JsonValue value = this.get(name);
        return value != null ? value.asString() : null;
    }

    public <T> T getStringAs(String name, Function<? super String, T> f) {
        return f.apply(this.getString(name));
    }

    public Double getDouble(String name) {
        JsonValue value = this.get(name);
        return value != null ? value.asDouble() : null;
    }

    public <T> T getDoubleAs(String name, Function<? super Double, T> f) {
        return f.apply(this.getDouble(name));
    }

    public Boolean getBoolean(String name) {
        JsonValue value = this.get(name);
        return value != null ? value.asBoolean() : null;
    }

    public <T> T getBoolean(String name, Function<? super Boolean, T> f) {
        return f.apply(this.getBoolean(name));
    }

    public JsonMap getMap(String name) {
        JsonValue value = this.get(name);
        return value != null ? value.asMap() : null;
    }

    public JsonList getList(String name) {
        JsonValue value = this.get(name);
        return value != null ? value.asList() : null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public JsonValue get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public JsonValue put(String key, JsonValue value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        this.delegate.putAll(m);
    }

    @Override
    public JsonValue remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<JsonValue> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public JsonValue getOrDefault(Object key, JsonValue defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public JsonValue putIfAbsent(String key, JsonValue value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(String key, JsonValue oldValue, JsonValue newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public JsonValue replace(String key, JsonValue value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public JsonValue computeIfAbsent(String key, Function<? super String, ? extends JsonValue> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public JsonValue computeIfPresent(String key, BiFunction<? super String, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public JsonValue compute(String key, BiFunction<? super String, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public JsonValue merge(String key, JsonValue value, BiFunction<? super JsonValue, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.delegate.merge(key, value, remappingFunction);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super JsonValue> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super JsonValue, ? extends JsonValue> function) {
        this.delegate.replaceAll(function);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonMap jsonMap = (JsonMap)o;
        return this.delegate.equals(jsonMap.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

