/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dbrain.data.text.ParseException;
import org.dbrain.data.text.Token;

public class TokenParser
implements AutoCloseable {
    public static String ERR_READER_NULL = "Reader is null.";
    public static String ERR_INVALID_CHARACTER = "Invalid character found.";
    public static String ERR_UNEXPECTED_EOS = "Unexpected end of stream.";
    public static String ERR_EXPECTED_NUMERIC = "Expected numeric litteral.";
    public static String ERR_EXPECTED_TOKEN = "Expected %s, found %s.";
    public static String ERR_WRONG_QUOTE = "Invalid quoting on the string litteral.";
    public static String ERR_EXPECTING_EOF = "Expecting end of stream.";
    private static char DOUBLE_QUOTE = (char)34;
    private static char SINGLE_QUOTE = (char)39;
    private static char LONG_QUOTE = (char)92;
    private static char SINGLE_CHAR_STRING = (char)36;
    private Reader reader;
    private boolean parsed = false;
    private char cur;
    private boolean eof = false;
    private Token curToken;
    private Object curValue;

    public TokenParser(Reader aReader) {
        if (aReader == null) {
            throw new IllegalArgumentException(ERR_READER_NULL);
        }
        this.reader = aReader;
    }

    public TokenParser(String s) {
        this(new StringReader(s));
    }

    public void raiseError(String msg) {
        throw new ParseException(msg);
    }

    public void raiseExpectedTokenError(Token foundToken, Token ... expectedTokens) {
        StringBuilder sb = new StringBuilder();
        for (Token t : expectedTokens) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(t.toString());
        }
        this.raiseError(String.format(ERR_EXPECTED_TOKEN, sb.toString(), foundToken.toString()));
    }

    private static int getBinDigitValue(char c) {
        return c >= '0' && c <= '1' ? c - 48 : -1;
    }

    private static int getDigitValue(char c) {
        return c >= '0' && c <= '9' ? c - 48 : -1;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static int getHexDigitValue(char c) {
        int result = c >= '0' && c <= '9' ? c - 48 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : -1));
        return result;
    }

    private static boolean isUnquotedStringStart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
            return true;
        }
        return Character.isLetter(c);
    }

    private static boolean isUnquotedStringPart(char c) {
        return TokenParser.isUnquotedStringStart(c) || TokenParser.isDigit(c);
    }

    private void readNextChar() {
        if (!this.eof) {
            try {
                int i = this.reader.read();
                this.eof = i < 0;
                this.cur = this.eof ? (char)'\u0000' : (char)i;
            }
            catch (IOException e) {
                this.raiseError(e.getMessage());
            }
        }
    }

    private void readNextCharMandatory() {
        this.readNextChar();
        if (this.eof) {
            this.raiseError(ERR_UNEXPECTED_EOS);
        }
    }

    private long parseBinary() {
        long result = 0L;
        int value = TokenParser.getBinDigitValue(this.cur);
        if (value < 0) {
            this.raiseError(ERR_EXPECTED_NUMERIC);
        }
        boolean ok = true;
        while (ok) {
            if (value >= 0) {
                result = result * 2L + (long)value;
                this.readNextChar();
            } else {
                ok = false;
            }
            value = TokenParser.getBinDigitValue(this.cur);
        }
        return result;
    }

    private long parseDecimal() {
        long result = 0L;
        int value = TokenParser.getDigitValue(this.cur);
        if (value < 0) {
            this.raiseError(ERR_EXPECTED_NUMERIC);
        }
        boolean ok = true;
        while (ok) {
            if (value >= 0) {
                result = result * 10L + (long)value;
                this.readNextChar();
            } else {
                ok = false;
            }
            value = TokenParser.getDigitValue(this.cur);
        }
        return result;
    }

    private long parseHexadecimal() {
        long result = 0L;
        int value = TokenParser.getHexDigitValue(this.cur);
        if (value < 0) {
            this.raiseError(ERR_EXPECTED_NUMERIC);
        }
        boolean ok = true;
        while (ok) {
            if (value >= 0) {
                result = result * 16L + (long)value;
                this.readNextChar();
            } else {
                ok = false;
            }
            value = TokenParser.getHexDigitValue(this.cur);
        }
        return result;
    }

    private long parseSignedDecimal() {
        boolean negative = false;
        if (this.cur == '-') {
            negative = true;
            this.readNextChar();
        }
        return negative ? -this.parseDecimal() : this.parseDecimal();
    }

    private Number parseNumeric(long scale) {
        long integralPart = 0L;
        double doublePart = 0.0;
        long exponent = 0L;
        boolean checkDouble = false;
        boolean isDouble = false;
        if (this.cur == '0') {
            this.readNextChar();
            switch (this.cur) {
                case 'X': 
                case 'x': {
                    this.readNextChar();
                    integralPart = this.parseHexadecimal();
                    break;
                }
                case 'B': 
                case 'b': {
                    this.readNextChar();
                    integralPart = this.parseBinary();
                    break;
                }
                case 'D': 
                case 'd': {
                    this.readNextChar();
                    integralPart = this.parseDecimal();
                    break;
                }
                default: {
                    integralPart = TokenParser.isDigit(this.cur) ? this.parseDecimal() : 0L;
                    checkDouble = true;
                    break;
                }
            }
        } else {
            integralPart = this.cur == '.' ? 0L : this.parseDecimal();
            checkDouble = true;
        }
        if (checkDouble) {
            if (this.cur == '.') {
                isDouble = true;
                double factor = 0.1;
                this.readNextChar();
                boolean ok = true;
                while (ok) {
                    int digit = TokenParser.getDigitValue(this.cur);
                    if (digit >= 0) {
                        doublePart += (double)digit * factor;
                        factor /= 10.0;
                        this.readNextChar();
                        continue;
                    }
                    ok = false;
                }
            }
            if (this.cur == 'E' || this.cur == 'e') {
                isDouble = true;
                this.readNextChar();
                exponent = this.parseSignedDecimal();
            }
        }
        if (isDouble) {
            return new Double((double)scale * ((double)integralPart + doublePart) * Math.pow(10.0, exponent));
        }
        return new Long(scale * integralPart);
    }

    private void parseUnquotedString(StringBuilder sb) {
        while (TokenParser.isUnquotedStringPart(this.cur)) {
            sb.append(this.cur);
            this.readNextChar();
        }
    }

    private void parseQuotedString(StringBuilder sb, boolean forbidControlCharacter) {
        boolean ok = true;
        char quote = this.cur;
        this.readNextCharMandatory();
        while (ok) {
            if (this.cur == quote) {
                this.readNextChar();
                ok = this.cur == quote;
                if (!ok) continue;
                sb.append(quote);
                this.readNextCharMandatory();
                continue;
            }
            if (forbidControlCharacter && this.cur < ' ') {
                this.raiseError(ERR_INVALID_CHARACTER);
            }
            sb.append(this.cur);
            this.readNextCharMandatory();
        }
    }

    private char parseSingleCharString() {
        if (this.cur != SINGLE_CHAR_STRING) {
            this.raiseError(ERR_INVALID_CHARACTER);
        }
        this.readNextChar();
        if (!TokenParser.isDigit(this.cur)) {
            this.raiseError(ERR_INVALID_CHARACTER);
        }
        return (char)this.parseNumeric(1L).byteValue();
    }

    private String parseMultiPartString() {
        StringBuilder result = new StringBuilder(256);
        boolean ok = true;
        while (ok) {
            if (TokenParser.isUnquotedStringStart(this.cur)) {
                this.parseUnquotedString(result);
                continue;
            }
            if (this.cur == DOUBLE_QUOTE || this.cur == SINGLE_QUOTE) {
                this.parseQuotedString(result, true);
                continue;
            }
            if (this.cur == LONG_QUOTE) {
                this.parseQuotedString(result, false);
                continue;
            }
            if (this.cur == SINGLE_CHAR_STRING) {
                result.append(this.parseSingleCharString());
                continue;
            }
            ok = false;
        }
        return result.toString();
    }

    private void setToken(Token aToken, Object aValue) {
        this.curToken = aToken;
        this.curValue = aValue;
        this.parsed = true;
    }

    private void setOpToken(Token aToken) {
        this.readNextChar();
        this.setToken(aToken, null);
    }

    private void setOpToken(Token aToken, char op1, Token aToken1) {
        this.readNextChar();
        if (this.cur == op1) {
            this.setToken(aToken1, null);
            this.readNextChar();
        } else {
            this.setToken(aToken, null);
        }
    }

    private void setOpToken(Token aToken, char op1, Token aToken1, char op2, Token aToken2) {
        this.readNextChar();
        if (this.cur == op1) {
            this.setToken(aToken1, null);
            this.readNextChar();
        } else if (this.cur == op2) {
            this.setToken(aToken2, null);
            this.readNextChar();
        } else {
            this.setToken(aToken, null);
        }
    }

    private void skipSingleLineComment() {
        this.readNextChar();
        boolean ok = true;
        while (ok) {
            ok = this.cur != '\r' && !this.eof;
            this.readNextChar();
        }
    }

    private void skipMultiLineComment() {
        this.readNextCharMandatory();
        boolean ok = true;
        while (ok) {
            if (this.cur == '*') {
                this.readNextCharMandatory();
                ok = this.cur != '/';
            }
            this.readNextCharMandatory();
        }
    }

    public Token getToken() {
        while (!this.parsed) {
            if (TokenParser.isDigit(this.cur)) {
                this.setToken(Token.NUMERIC, this.parseNumeric(1L));
            } else if (TokenParser.isUnquotedStringStart(this.cur)) {
                String identifier = this.parseMultiPartString();
                this.setToken(Token.KEYWORD, identifier);
            } else if (this.cur == DOUBLE_QUOTE) {
                this.setToken(Token.STRING, this.parseMultiPartString());
            } else if (this.cur == SINGLE_QUOTE) {
                this.setToken(Token.IDENTIFIER, this.parseMultiPartString());
            } else if (this.cur == LONG_QUOTE) {
                this.setToken(Token.STRING, this.parseMultiPartString());
            } else if (this.cur == SINGLE_CHAR_STRING) {
                this.setToken(Token.STRING, this.parseMultiPartString());
            } else {
                block0 : switch (this.cur) {
                    case '(': {
                        this.setOpToken(Token.OPEN_PARENTESIS);
                        break;
                    }
                    case '[': {
                        this.setOpToken(Token.OPEN_BRACKET);
                        break;
                    }
                    case '{': {
                        this.setOpToken(Token.OPEN_ALINEAS);
                        break;
                    }
                    case ')': {
                        this.setOpToken(Token.CLOSE_PARENTESIS);
                        break;
                    }
                    case ']': {
                        this.setOpToken(Token.CLOSE_BRACKET);
                        break;
                    }
                    case '}': {
                        this.setOpToken(Token.CLOSE_ALINEAS);
                        break;
                    }
                    case '+': {
                        this.setOpToken(Token.PLUS, '+', Token.INCREMENT, '=', Token.PLUS_EQUAL);
                        break;
                    }
                    case '-': {
                        this.setOpToken(Token.MINUS, '-', Token.DECREMENT, '=', Token.MINUS_EQUAL);
                        break;
                    }
                    case '*': {
                        this.setOpToken(Token.MULTIPLY, '=', Token.MULTIPLY_EQUAL);
                        break;
                    }
                    case '%': {
                        this.setOpToken(Token.MODULUS, '=', Token.MODULUS_EQUAL);
                        break;
                    }
                    case '<': {
                        this.setOpToken(Token.LESSER, '=', Token.LESSER_EQUAL);
                        break;
                    }
                    case '>': {
                        this.setOpToken(Token.GREATER, '=', Token.GREATER_EQUAL);
                        break;
                    }
                    case ':': {
                        this.setOpToken(Token.COLON, '=', Token.COLON_EQUAL);
                        break;
                    }
                    case '=': {
                        this.setOpToken(Token.EQUAL);
                        break;
                    }
                    case '@': {
                        this.setOpToken(Token.AT);
                        break;
                    }
                    case '&': {
                        this.setOpToken(Token.BW_AND, '&', Token.AND);
                        break;
                    }
                    case '|': {
                        this.setOpToken(Token.BW_OR, '|', Token.OR);
                        break;
                    }
                    case '^': {
                        this.setOpToken(Token.BW_XOR);
                        break;
                    }
                    case '~': {
                        this.setOpToken(Token.BW_NOT);
                        break;
                    }
                    case '!': {
                        this.setOpToken(Token.NOT);
                        break;
                    }
                    case '.': {
                        this.setOpToken(Token.DOT);
                        break;
                    }
                    case ',': {
                        this.setOpToken(Token.SEP);
                        break;
                    }
                    case ';': {
                        this.setOpToken(Token.EOS);
                        break;
                    }
                    case '/': {
                        this.readNextChar();
                        switch (this.cur) {
                            case '/': {
                                this.skipSingleLineComment();
                                break block0;
                            }
                            case '*': {
                                this.skipMultiLineComment();
                                break block0;
                            }
                            case '=': {
                                this.setOpToken(Token.DIVIDE_EQUAL);
                                break block0;
                            }
                        }
                        this.setToken(Token.DIVIDE, null);
                        break;
                    }
                    default: {
                        if (this.cur <= ' ') {
                            this.readNextChar();
                            break;
                        }
                        this.raiseError(ERR_INVALID_CHARACTER);
                    }
                }
            }
            if (this.parsed || !this.eof) continue;
            this.setToken(Token.EOF, null);
        }
        return this.curToken;
    }

    public boolean isToken(Token validToken1) {
        Token retval = this.getToken();
        return retval == validToken1;
    }

    public boolean isToken(Token validToken1, Token validToken2) {
        Token retval = this.getToken();
        return retval == validToken1 || retval == validToken2;
    }

    public boolean isToken(Token validToken1, Token validToken2, Token validToken3) {
        Token retval = this.getToken();
        return retval == validToken1 || retval == validToken2 || retval == validToken3;
    }

    public Token getValidToken(Token expectedToken1) {
        if (!this.isToken(expectedToken1)) {
            this.raiseExpectedTokenError(this.getToken(), expectedToken1);
        }
        return this.getToken();
    }

    public Token getValidToken(Token expectedToken1, Token expectedToken2) {
        if (!this.isToken(expectedToken1, expectedToken2)) {
            this.raiseExpectedTokenError(this.getToken(), expectedToken1);
        }
        return this.getToken();
    }

    public Token getValidToken(Token expectedToken1, Token expectedToken2, Token expectedToken3) {
        if (!this.isToken(expectedToken1, expectedToken2, expectedToken3)) {
            this.raiseExpectedTokenError(this.getToken(), expectedToken1);
        }
        return this.getToken();
    }

    public Number getNumeric() {
        return (Number)this.get(Token.NUMERIC);
    }

    public Number readNumeric() {
        Number result = this.getNumeric();
        this.consume();
        return result;
    }

    public String getKeyword() {
        return (String)this.get(Token.KEYWORD);
    }

    public String readKeyword() {
        String result = this.getKeyword();
        this.consume();
        return result;
    }

    public String getIdentifier() {
        return (String)this.get(Token.IDENTIFIER);
    }

    public String readIdentifier() {
        String result = this.getIdentifier();
        this.consume();
        return result;
    }

    public String getString() {
        return (String)this.get(Token.STRING);
    }

    public String readString() {
        String result = this.getString();
        this.consume();
        return result;
    }

    public Object get(Token expectedToken1) {
        this.getValidToken(expectedToken1);
        return this.curValue;
    }

    public Object get(Token expectedToken1, Token expectedToken2) {
        this.getValidToken(expectedToken1, expectedToken2);
        return this.curValue;
    }

    public Object get(Token expectedToken1, Token expectedToken2, Token expectedToken3) {
        this.getValidToken(expectedToken1, expectedToken2, expectedToken3);
        return this.curValue;
    }

    public Object read(Token expectedToken1) {
        Object result = this.get(expectedToken1);
        this.consume();
        return result;
    }

    public Object read(Token expectedToken1, Token expectedToken2) {
        Object result = this.get(expectedToken1, expectedToken2);
        this.consume();
        return result;
    }

    public Object read(Token expectedToken1, Token expectedToken2, Token expectedToken3) {
        Object result = this.get(expectedToken1, expectedToken2, expectedToken3);
        this.consume();
        return result;
    }

    public boolean consume() {
        if (this.getToken() == Token.EOF) {
            return false;
        }
        this.curToken = null;
        this.curValue = null;
        this.parsed = false;
        return true;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.raiseError(e.getMessage());
        }
    }
}

