/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dbrain.data.Fqn;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public final class FqnImpl
implements Fqn {
    private static final String RESERVED_CHARS = "*'\"?!@#%&()[]{}.,;+-/\\^ ";
    private static final Fqn NULL_VALUE = new FqnImpl(null);
    private final List<String> segments;

    public static Fqn of(ReaderCursor c) {
        if (FqnImpl.isFqnStart(c.get())) {
            ArrayList<String> segments = new ArrayList<String>();
            segments.add(FqnImpl.readSegment(c));
            while (c.get() == 46) {
                c.read();
                segments.add(FqnImpl.readSegment(c));
            }
            return new FqnImpl(segments);
        }
        return NULL_VALUE;
    }

    public static Fqn of(String fqn) {
        if (fqn == null) {
            return NULL_VALUE;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        while (ParserUtils.isSpace(c.get())) {
            c.read();
        }
        Fqn result = FqnImpl.of(c);
        while (ParserUtils.isSpace(c.get())) {
            c.read();
        }
        if (c.get() >= 0) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    private static boolean isReserved(int cur) {
        return RESERVED_CHARS.indexOf(cur) >= 0;
    }

    private static boolean isQuote(int cur) {
        return cur == 39;
    }

    private static boolean isFqnStart(int cur) {
        return cur >= 0 && (FqnImpl.isQuote(cur) || !FqnImpl.isReserved(cur));
    }

    private static boolean isUnquotedSegment(int cur) {
        return cur >= 0 && !FqnImpl.isReserved(cur);
    }

    private static String readQuotedSegment(ReaderCursor c) {
        int quote = c.read();
        StringBuilder sb = new StringBuilder();
        while (true) {
            int current;
            if ((current = c.read()) == quote) {
                if (c.get() != quote) break;
                sb.appendCodePoint(c.read());
                continue;
            }
            if (current < 0) {
                throw c.error("Unexpected eof");
            }
            sb.appendCodePoint(current);
        }
        return sb.toString();
    }

    private static String readUnquotedSegment(ReaderCursor cursor) {
        StringBuilder sb = new StringBuilder();
        while (FqnImpl.isUnquotedSegment(cursor.get())) {
            sb.appendCodePoint(cursor.read());
        }
        return sb.toString();
    }

    private static String readSegment(ReaderCursor c) {
        if (FqnImpl.isQuote(c.get())) {
            return FqnImpl.readQuotedSegment(c);
        }
        return FqnImpl.readUnquotedSegment(c);
    }

    private static String encodeSegment(String segment) {
        if (segment.length() == 0) {
            return "''";
        }
        StringBuilder sb = null;
        for (int i = 0; i < segment.length(); ++i) {
            Character c = Character.valueOf(segment.charAt(i));
            if (RESERVED_CHARS.indexOf(c.charValue()) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder(segment.length() + 12);
                    sb.append("'");
                    sb.append(segment.substring(0, i));
                }
                if (c.charValue() == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            sb.append("'");
            return sb.toString();
        }
        return segment;
    }

    private FqnImpl(List<String> segments) {
        this.segments = segments != null && segments.size() > 0 ? new ArrayList<String>(segments) : null;
    }

    @Override
    public int size() {
        return this.segments != null ? this.segments.size() : 0;
    }

    @Override
    public String segment(int i) {
        if (this.segments != null) {
            return this.segments.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean startsWith(Fqn other) {
        if (other == null || other == this) {
            return true;
        }
        int otherSize = other.size();
        if (this.size() < otherSize) {
            return false;
        }
        for (int i = 0; i < otherSize; ++i) {
            if (this.segment(i).equals(other.segment(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fqn fqn = (Fqn)o;
        if (this.size() != fqn.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.segment(i).equals(fqn.segment(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return FqnImpl.encodeSegment(this.segment(0));
        }
        StringBuilder sb = null;
        for (int i = 0; i < size; ++i) {
            String s = this.segment(i);
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(".");
            }
            sb.append(FqnImpl.encodeSegment(s));
        }
        return sb.toString();
    }
}

