/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.util.Arrays;
import org.dbrain.data.impl.fqn.FqnBuilderImpl;
import org.dbrain.data.impl.fqn.FqnImpl;
import org.dbrain.data.impl.fqn.FqnUtils;
import org.dbrain.data.text.ReaderCursor;

public interface Fqn {
    public static Fqn of(ReaderCursor c) {
        return FqnUtils.parseFqn(c);
    }

    public static Fqn of(String fqn) {
        return FqnUtils.parseFqn(fqn);
    }

    public static Fqn ofSegment(String segment) {
        if (segment != null) {
            return new FqnImpl(Arrays.asList(segment));
        }
        return Fqn.of((String)null);
    }

    public static Builder fromSegment(String segment) {
        return Fqn.newBuilder().segment(segment);
    }

    public static Builder from(Fqn fqn) {
        return Fqn.newBuilder().append(fqn);
    }

    public static Builder newBuilder() {
        return new FqnBuilderImpl();
    }

    public int size();

    public String segment(int var1);

    public boolean startsWith(Fqn var1);

    public static interface Builder {
        public Builder segment(String var1);

        public Builder append(Fqn var1);

        public Fqn build();
    }
}

