/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.fqn;

import java.io.StringReader;
import java.util.ArrayList;
import org.dbrain.data.Fqn;
import org.dbrain.data.FqnPattern;
import org.dbrain.data.impl.fqn.FqnImpl;
import org.dbrain.data.impl.fqn.FqnPatternBuilderImpl;
import org.dbrain.data.impl.fqn.FqnPatternImpl;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public class FqnUtils {
    public static final String FQN_PATTERN_RESERVED_CHARS = "'\"?!@#%&()[]{}.,;+-/\\^ ";
    public static final String FQN_RESERVED_CHARS = "*'\"?!@#%&()[]{}.,;+-/\\^ ";

    public static Fqn parseFqn(ReaderCursor c) {
        FqnUtils.skipWhitespace(c);
        if (FqnUtils.isFqnStart(c.get())) {
            ArrayList<String> segments = new ArrayList<String>();
            segments.add(FqnUtils.readSegment(c));
            while (c.get() == 46) {
                c.read();
                segments.add(FqnUtils.readSegment(c));
            }
            return new FqnImpl(segments);
        }
        return FqnImpl.EMPTY_NAME;
    }

    public static Fqn parseFqn(String fqn) {
        if (fqn == null) {
            return FqnImpl.EMPTY_NAME;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        Fqn result = FqnUtils.parseFqn(c);
        FqnUtils.skipWhitespace(c);
        if (c.get() >= 0) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    public static FqnPattern parseFqnPattern(ReaderCursor c) {
        FqnUtils.skipWhitespace(c);
        if (FqnUtils.isFqnPatternStart(c.get())) {
            FqnPatternBuilderImpl builder = new FqnPatternBuilderImpl();
            FqnUtils.readPatternSegment(c, builder);
            while (c.get() == 46) {
                c.read();
                FqnUtils.readPatternSegment(c, builder);
            }
            return builder.build();
        }
        return new FqnPatternBuilderImpl().build();
    }

    public static FqnPattern parseFqnPattern(String fqn) {
        if (fqn == null) {
            return FqnPatternImpl.EMPTY_PATTERN;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        FqnPattern result = FqnUtils.parseFqnPattern(c);
        FqnUtils.skipWhitespace(c);
        if (c.get() >= 0) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    private static void skipWhitespace(ReaderCursor c) {
        while (ParserUtils.isSpace(c.get())) {
            c.read();
        }
    }

    private static boolean isNotFqnReserved(int cur) {
        return FQN_RESERVED_CHARS.indexOf(cur) < 0;
    }

    private static boolean isNotFqnPatternReserved(int cur) {
        return FQN_PATTERN_RESERVED_CHARS.indexOf(cur) < 0;
    }

    private static boolean isQuote(int cur) {
        return cur == 39;
    }

    private static boolean isWildcard(int cur) {
        return cur == 42;
    }

    private static boolean isFqnStart(int cur) {
        return cur >= 0 && (FqnUtils.isQuote(cur) || FqnUtils.isNotFqnReserved(cur));
    }

    private static boolean isFqnPatternStart(int cur) {
        return cur >= 0 && (FqnUtils.isQuote(cur) || FqnUtils.isNotFqnPatternReserved(cur));
    }

    private static boolean isUnquotedSegment(int cur) {
        return cur >= 0 && FqnUtils.isNotFqnReserved(cur);
    }

    private static String readQuotedSegment(ReaderCursor c) {
        int quote = c.read();
        StringBuilder sb = new StringBuilder();
        while (true) {
            int current;
            if ((current = c.read()) == quote) {
                if (c.get() != quote) break;
                sb.appendCodePoint(c.read());
                continue;
            }
            if (current < 0) {
                throw c.error("Unexpected eof");
            }
            sb.appendCodePoint(current);
        }
        return sb.toString();
    }

    private static String readUnquotedSegment(ReaderCursor cursor) {
        StringBuilder sb = new StringBuilder();
        while (FqnUtils.isUnquotedSegment(cursor.get())) {
            sb.appendCodePoint(cursor.read());
        }
        return sb.toString();
    }

    private static String readSegment(ReaderCursor c) {
        if (FqnUtils.isQuote(c.get())) {
            return FqnUtils.readQuotedSegment(c);
        }
        return FqnUtils.readUnquotedSegment(c);
    }

    private static void readWildcardSegment(ReaderCursor c, FqnPattern.Builder to) {
        if (FqnUtils.isWildcard(c.getNext())) {
            to.any();
            c.read();
        } else {
            to.one();
        }
    }

    private static void readPatternSegment(ReaderCursor c, FqnPattern.Builder to) {
        int cur = c.get();
        if (FqnUtils.isQuote(cur)) {
            to.segment(FqnUtils.readQuotedSegment(c));
        } else if (FqnUtils.isWildcard(cur)) {
            FqnUtils.readWildcardSegment(c, to);
        } else {
            to.segment(FqnUtils.readUnquotedSegment(c));
        }
    }

    static String encodeSegment(String segment) {
        if (segment.length() == 0) {
            return "''";
        }
        StringBuilder sb = null;
        for (int i = 0; i < segment.length(); ++i) {
            Character c = Character.valueOf(segment.charAt(i));
            if (FQN_RESERVED_CHARS.indexOf(c.charValue()) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder(segment.length() + 12);
                    sb.append("'");
                    sb.append(segment.substring(0, i));
                }
                if (c.charValue() == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            sb.append("'");
            return sb.toString();
        }
        return segment;
    }
}

