/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.text;

import java.io.Reader;
import org.dbrain.data.text.ReaderCursor;

public class LineCursor {
    private boolean eof = false;
    private ReaderCursor cursor;
    private String currentLine;

    public LineCursor(Reader r) {
        this.cursor = new ReaderCursor(r);
    }

    private void load() {
        if (this.currentLine == null && !this.eof) {
            int current = this.cursor.get();
            if (current >= 0) {
                StringBuilder sb = new StringBuilder();
                while (current >= 0 && current != 13 && current != 10) {
                    sb.append((char)current);
                    current = this.cursor.getNext();
                }
                if (current == 13 && this.cursor.getNext() == 10) {
                    this.cursor.read();
                }
                if (current == 10 && this.cursor.getNext() == 13) {
                    this.cursor.read();
                }
                this.currentLine = sb.toString();
            } else {
                this.eof = true;
                this.currentLine = null;
            }
        }
    }

    public String get() {
        this.load();
        return this.currentLine;
    }

    public String getNext() {
        this.read();
        return this.get();
    }

    public String read() {
        String result = this.get();
        this.currentLine = null;
        return result;
    }
}

