/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.function.Function;
import org.dbrain.data.DataTruncationException;

public class Numbers {
    public static Function<BigDecimal, BigDecimal> setDecimalParameters(final int precision, final int scale, final RoundingMode rounding) {
        return new Function<BigDecimal, BigDecimal>(){
            final MathContext mathContext;
            {
                this.mathContext = new MathContext(precision, rounding);
            }

            @Override
            public BigDecimal apply(BigDecimal bigDecimal) {
                if (bigDecimal == null) {
                    return null;
                }
                return bigDecimal.setScale(scale, this.mathContext.getRoundingMode());
            }
        };
    }

    public static Function<String, Number> numberParser(final NumberFormat df) {
        return new Function<String, Number>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Number apply(String s) {
                if (s == null) {
                    return null;
                }
                2 var2_2 = this;
                synchronized (var2_2) {
                    ParsePosition pp = new ParsePosition(0);
                    Number result = df.parse(s, pp);
                    if (pp.getIndex() != s.length()) {
                        throw new DataTruncationException();
                    }
                    return result;
                }
            }
        };
    }
}

