/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.ValueList;
import org.dbrain.data.ValueMap;
import org.dbrain.data.access.FieldAccessors;
import org.dbrain.data.impl.value.BoolValueImpl;
import org.dbrain.data.impl.value.NullValueImpl;
import org.dbrain.data.impl.value.NumberValueImpl;
import org.dbrain.data.impl.value.StringValueImpl;

public interface Value
extends FieldAccessors {
    public static Value nullValue() {
        return NullValueImpl.NULL;
    }

    public static Value of(String s) {
        return s != null ? new StringValueImpl(s) : Value.nullValue();
    }

    public static Value of(CharSequence s) {
        return s != null ? new StringValueImpl(s.toString()) : Value.nullValue();
    }

    public static Value of(Byte b) {
        return b != null ? new NumberValueImpl(b) : Value.nullValue();
    }

    public static Value of(Short s) {
        return s != null ? new NumberValueImpl(s) : Value.nullValue();
    }

    public static Value of(Integer i) {
        return i != null ? new NumberValueImpl(i) : Value.nullValue();
    }

    public static Value of(Long l) {
        return l != null ? new NumberValueImpl(l) : Value.nullValue();
    }

    public static Value of(BigInteger bi) {
        return bi != null ? new NumberValueImpl(bi) : Value.nullValue();
    }

    public static Value of(BigDecimal bd) {
        return bd != null ? new NumberValueImpl(bd) : Value.nullValue();
    }

    public static Value of(Float v) {
        if (v != null) {
            float value = v.floatValue();
            if (Float.isNaN(value)) {
                return Value.nullValue();
            }
            if (Float.isFinite(value)) {
                return new NumberValueImpl(value);
            }
            throw new DataCoercionException("Value cannot contain infinity.");
        }
        return Value.nullValue();
    }

    public static Value of(Double v) {
        if (v != null) {
            double doubleValue = v;
            if (Double.isNaN(doubleValue)) {
                return Value.nullValue();
            }
            if (Double.isFinite(doubleValue)) {
                return new NumberValueImpl(doubleValue);
            }
            throw new DataCoercionException("Value cannot contain infinity.");
        }
        return Value.nullValue();
    }

    public static Value of(Boolean b) {
        if (b != null) {
            return b != false ? BoolValueImpl.TRUE : BoolValueImpl.FALSE;
        }
        return Value.nullValue();
    }

    public static Value of(Value v) {
        return v != null ? v : Value.nullValue();
    }

    public static Value of(Object v, Function<Object, Value> valueFromObject) {
        if (v == null) {
            return Value.nullValue();
        }
        if (v instanceof Value) {
            return (Value)v;
        }
        if (v instanceof String) {
            return Value.of((String)v);
        }
        if (v instanceof Byte) {
            return Value.of((Byte)v);
        }
        if (v instanceof Short) {
            return Value.of((Short)v);
        }
        if (v instanceof Integer) {
            return Value.of((Integer)v);
        }
        if (v instanceof Long) {
            return Value.of((Long)v);
        }
        if (v instanceof BigDecimal) {
            return Value.of((BigDecimal)v);
        }
        if (v instanceof BigInteger) {
            return Value.of((BigInteger)v);
        }
        if (v instanceof Float) {
            return Value.of((Float)v);
        }
        if (v instanceof Double) {
            return Value.of((Double)v);
        }
        if (v instanceof Boolean) {
            return Value.of((Boolean)v);
        }
        return valueFromObject.apply(v);
    }

    public static Value of(Object o) {
        return Value.of(o, o1 -> {
            throw new DataCoercionException("Cannot cast " + o1.getClass().getName() + " to value.");
        });
    }

    public ValueMap getMap();

    public ValueList getList();

    public boolean isNull();
}

