/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.fqn;

import org.dbrain.data.FqnPattern;
import org.dbrain.data.impl.fqn.FqnPatternImpl;

public class FqnPatternBuilderImpl
implements FqnPattern.Builder {
    private int partCount = 0;
    private FqnPatternImpl.Node root = null;
    private FqnPatternImpl.Node tail = null;

    private void addNode(FqnPatternImpl.Node node) {
        if (this.tail == null) {
            this.root = node;
            this.tail = node;
        } else {
            this.tail.setNext(node);
            this.tail = node;
        }
        if (node instanceof FqnPatternImpl.PartMatchingNode) {
            ((FqnPatternImpl.PartMatchingNode)((Object)node)).setPartIdx(this.partCount++);
        }
    }

    @Override
    public FqnPattern.Builder segment(String segment) {
        this.addNode(new FqnPatternImpl.SpecificNode(segment));
        return this;
    }

    @Override
    public FqnPattern.Builder one() {
        this.addNode(new FqnPatternImpl.OneNode());
        return this;
    }

    @Override
    public FqnPattern.Builder any() {
        this.addNode(new FqnPatternImpl.ManyNode());
        return this;
    }

    @Override
    public FqnPattern build() {
        try {
            FqnPattern fqnPattern = this.root != null ? new FqnPatternImpl(this.root, this.partCount) : FqnPatternImpl.EMPTY_PATTERN;
            return fqnPattern;
        }
        finally {
            this.root = null;
            this.tail = null;
            this.partCount = 0;
        }
    }
}

