/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import org.dbrain.data.Value;
import org.dbrain.data.impl.json.jackson.JsonModule;
import org.dbrain.data.impl.json.jackson.JsonValueParser;
import org.dbrain.data.json.JsonBridge;
import org.dbrain.data.text.ParseException;

public class JacksonJsonBridge
implements JsonBridge {
    private ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).registerModule((Module)new JsonModule());

    private void checkEof(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (parser.getCurrentToken() != null) {
            throw new ParseException("Unexpected json token: " + token.name());
        }
    }

    @Override
    public Value parseValue(String r) {
        try {
            JsonParser parser = this.objectMapper.getFactory().createParser(r);
            Value v = this.parseValue(parser);
            this.checkEof(parser);
            return v;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value parseValue(Reader r) {
        try (Reader r2 = r;){
            JsonParser parser = this.objectMapper.getFactory().createParser(r2);
            Value v = this.parseValue(parser);
            this.checkEof(parser);
            Value value = v;
            return value;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public Value parseValue(JsonParser r) {
        try {
            return JsonValueParser.parseValue(r);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public <T> T parseObject(JsonParser r, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(r, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public <T> T parseObject(String r, Class<T> clazz) {
        try {
            JsonParser parser = this.objectMapper.getFactory().createParser(r);
            T value = this.parseObject(parser, clazz);
            this.checkEof(parser);
            return value;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Value objectToValue(Object o) {
        try {
            return (Value)this.objectMapper.convertValue(o, Value.class);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public String writeToString(Object o) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

