/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class JsonBigDecimalSerializer
extends JsonSerializer<BigDecimal> {
    private BigInteger MAX_VALUE = new BigInteger("999999999999999");
    private BigInteger MIN_VALUE = new BigInteger("-999999999999999");

    JsonBigDecimalSerializer() {
    }

    public void serialize(BigDecimal value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null) {
            BigInteger unscaled = value.unscaledValue();
            if (unscaled.compareTo(this.MIN_VALUE) >= 0 && unscaled.compareTo(this.MAX_VALUE) <= 0) {
                jgen.writeNumber(value);
            } else {
                jgen.writeString(value.toString());
            }
        } else {
            jgen.writeNull();
        }
    }
}

