/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.json.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import org.dbrain.data.Value;
import org.dbrain.data.ValueList;
import org.dbrain.data.ValueMap;
import org.dbrain.data.impl.value.NullValueImpl;

public class JsonValueParser {
    public static JsonToken nextToker(JsonParser parser) throws IOException {
        return parser.hasCurrentToken() ? parser.getCurrentToken() : parser.nextValue();
    }

    public static Value parseValue(JsonParser parser) throws IOException {
        JsonToken token = JsonValueParser.nextToker(parser);
        if (token != null) {
            Value result;
            switch (token) {
                case VALUE_STRING: {
                    result = Value.of(parser.getValueAsString());
                    parser.clearCurrentToken();
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = Value.of(parser.getDoubleValue());
                    parser.clearCurrentToken();
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = Value.of(parser.getBigIntegerValue());
                    parser.clearCurrentToken();
                    break;
                }
                case VALUE_NULL: {
                    result = NullValueImpl.NULL;
                    parser.clearCurrentToken();
                    break;
                }
                case VALUE_TRUE: {
                    result = Value.of(Boolean.TRUE);
                    parser.clearCurrentToken();
                    break;
                }
                case VALUE_FALSE: {
                    result = Value.of(Boolean.FALSE);
                    parser.clearCurrentToken();
                    break;
                }
                case START_OBJECT: {
                    parser.clearCurrentToken();
                    ValueMap values = ValueMap.newInstance();
                    while (JsonValueParser.nextToker(parser) != JsonToken.END_OBJECT) {
                        String key = parser.getCurrentName();
                        Value v = JsonValueParser.parseValue(parser);
                        if (v == null) {
                            throw new JsonParseException("Expected JSON value.", parser.getCurrentLocation());
                        }
                        values.put(key, v);
                    }
                    if (JsonValueParser.nextToker(parser) != JsonToken.END_OBJECT) {
                        throw new JsonParseException("Expected end of object.", parser.getCurrentLocation());
                    }
                    parser.clearCurrentToken();
                    result = values;
                    break;
                }
                case START_ARRAY: {
                    parser.clearCurrentToken();
                    ValueList values = ValueList.newInstance();
                    while (JsonValueParser.nextToker(parser) != JsonToken.END_ARRAY) {
                        Value v = JsonValueParser.parseValue(parser);
                        if (v == null) {
                            throw new JsonParseException("Expected value.", parser.getCurrentLocation());
                        }
                        values.add(v);
                    }
                    if (JsonValueParser.nextToker(parser) != JsonToken.END_ARRAY) {
                        throw new JsonParseException("Expected end of array.", parser.getCurrentLocation());
                    }
                    parser.clearCurrentToken();
                    result = values;
                    break;
                }
                default: {
                    throw new JsonParseException("Expected value.", parser.getCurrentLocation());
                }
            }
            return result;
        }
        return null;
    }
}

