/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.value;

import java.util.Objects;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.Value;
import org.dbrain.data.impl.value.ListValueImpl;
import org.dbrain.data.impl.value.MapValueImpl;

public final class BoolValueImpl
implements Value {
    public static final Value TRUE = new BoolValueImpl(Boolean.TRUE);
    public static final Value FALSE = new BoolValueImpl(Boolean.FALSE);
    private final Boolean value;

    public BoolValueImpl(Boolean value) {
        Objects.nonNull(value);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public MapValueImpl getMap() {
        throw new DataCoercionException("Cannot cast boolean to Map.");
    }

    @Override
    public ListValueImpl getList() {
        throw new DataCoercionException("Cannot cast boolean to List.");
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoolValueImpl value1 = (BoolValueImpl)o;
        return !(this.value == null ? value1.value != null : !this.value.equals(value1.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value.toString();
    }
}

