/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.value;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.Value;
import org.dbrain.data.ValueList;
import org.dbrain.data.ValueMap;
import org.dbrain.data.json.JsonBridge;

public class MapValueImpl
implements ValueMap {
    private final HashMap<String, Value> delegate;

    public MapValueImpl(HashMap<String, Value> delegate) {
        this.delegate = delegate;
    }

    public MapValueImpl() {
        this(new HashMap<String, Value>());
    }

    @Override
    public Object getObject() {
        HashMap result = new HashMap(this.size());
        this.delegate.forEach((? super K s, ? super V value) -> result.put(s, value.getObject()));
        return result;
    }

    @Override
    public Object getObject(String fieldName) {
        return this.get(fieldName).getObject();
    }

    @Override
    public Boolean getBoolean() {
        throw new DataCoercionException("Cannot cast map to boolean.");
    }

    @Override
    public Byte getByte() {
        throw new DataCoercionException("Cannot cast map to byte.");
    }

    @Override
    public Short getShort() {
        throw new DataCoercionException("Cannot cast map to short.");
    }

    @Override
    public Integer getInt() {
        throw new DataCoercionException("Cannot cast map to integer.");
    }

    @Override
    public Long getLong() {
        throw new DataCoercionException("Cannot cast map to long.");
    }

    @Override
    public Float getFloat() {
        throw new DataCoercionException("Cannot cast map to float.");
    }

    @Override
    public Double getDouble() {
        throw new DataCoercionException("Cannot cast map to double.");
    }

    @Override
    public String getString() {
        throw new DataCoercionException("Cannot cast map to string.");
    }

    @Override
    public MapValueImpl getMap() {
        return this;
    }

    @Override
    public ValueList getList() {
        throw new DataCoercionException("Cannot cast map to list.");
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Value get(Object key) {
        return Value.of(this.delegate.get(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public Value put(String key, Value value) {
        return this.delegate.put(key, Value.of(value));
    }

    @Override
    public void putAll(Map<? extends String, ? extends Value> m) {
        for (Map.Entry<? extends String, ? extends Value> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Value remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(Value.of(value));
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Value> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Value>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Value getOrDefault(Object key, Value defaultValue) {
        Value result = this.get(key);
        return result.isNull() ? Value.of(defaultValue) : result;
    }

    @Override
    public Value putIfAbsent(String key, Value value) {
        if (!this.containsKey(key)) {
            return this.put(key, Value.of(value));
        }
        return this.get(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, Value.of(value));
    }

    @Override
    public boolean replace(String key, Value oldValue, Value newValue) {
        return this.delegate.replace(key, Value.of(oldValue), Value.of(newValue));
    }

    @Override
    public Value replace(String key, Value value) {
        return this.delegate.replace(key, Value.of(value));
    }

    @Override
    public Value computeIfAbsent(String key, Function<? super String, ? extends Value> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Value computeIfPresent(String key, BiFunction<? super String, ? super Value, ? extends Value> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Value compute(String key, BiFunction<? super String, ? super Value, ? extends Value> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public Value merge(String key, Value value, BiFunction<? super Value, ? super Value, ? extends Value> remappingFunction) {
        return this.delegate.merge(key, value, remappingFunction);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Value> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Value, ? extends Value> function) {
        this.delegate.replaceAll(function);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return JsonBridge.get().writeToString(this);
    }
}

