/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.Value;
import org.dbrain.data.impl.value.ListValueImpl;
import org.dbrain.data.impl.value.MapValueImpl;

public final class NumberValueImpl
implements Value {
    private final BigDecimal value;

    public NumberValueImpl(Byte value) {
        Objects.nonNull(value);
        this.value = new BigDecimal(value.byteValue());
    }

    public NumberValueImpl(Short value) {
        Objects.nonNull(value);
        this.value = new BigDecimal(value.shortValue());
    }

    public NumberValueImpl(Integer value) {
        Objects.nonNull(value);
        this.value = new BigDecimal(value);
    }

    public NumberValueImpl(Long value) {
        Objects.nonNull(value);
        this.value = new BigDecimal(value);
    }

    public NumberValueImpl(BigInteger value) {
        Objects.nonNull(value);
        this.value = new BigDecimal(value);
    }

    public NumberValueImpl(BigDecimal value) {
        Objects.nonNull(value);
        this.value = value;
    }

    public NumberValueImpl(float value) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException();
        }
        this.value = new BigDecimal(Float.toString(value)).stripTrailingZeros();
    }

    public NumberValueImpl(double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException();
        }
        this.value = new BigDecimal(Double.toString(value)).stripTrailingZeros();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public MapValueImpl getMap() {
        throw new DataCoercionException("Cannot cast number to Map.");
    }

    @Override
    public ListValueImpl getList() {
        throw new DataCoercionException("Cannot cast number to List.");
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberValueImpl that = (NumberValueImpl)o;
        return this.value.compareTo(that.value) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

