/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.value;

import java.util.Objects;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.Value;
import org.dbrain.data.impl.value.ListValueImpl;
import org.dbrain.data.impl.value.MapValueImpl;

public final class StringValueImpl
implements Value {
    private final String value;

    public StringValueImpl(String value) {
        Objects.nonNull(value);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public MapValueImpl getMap() {
        throw new DataCoercionException("Cannot cast string to Map.");
    }

    @Override
    public ListValueImpl getList() {
        throw new DataCoercionException("Cannot cast string to List.");
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValueImpl value1 = (StringValueImpl)o;
        return !(this.value == null ? value1.value != null : !this.value.equals(value1.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value;
    }
}

