/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.util;

import java.util.Comparator;
import java.util.Locale;
import org.dbrain.data.DataTruncationException;

public class Strings {
    public static final Comparator<String> NATURAL_ORDER = (o1, o2) -> {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        return o2 == null ? 1 : o1.compareTo((String)o2);
    };

    public static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    public static String rtrim(String s) {
        if (s != null) {
            int initialPos;
            int i;
            for (i = initialPos = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
            }
            if (i == initialPos) {
                return s;
            }
            return s.substring(0, i + 1);
        }
        return null;
    }

    public static String ltrim(String s) {
        if (s != null) {
            int i;
            for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i == 0) {
                return s;
            }
            return s.substring(i, s.length());
        }
        return null;
    }

    public static boolean isBlank(CharSequence s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String blankToNull(String s) {
        return s == null || Strings.isBlank(s) ? null : s;
    }

    public static String nullToBlank(String s) {
        return s == null ? "" : s;
    }

    public static String maxLength(String s, int length) {
        if (s == null) {
            return null;
        }
        if (s.length() <= length) {
            return s;
        }
        throw new DataTruncationException();
    }

    public static String lowercase(String s, Locale locale) {
        return s != null ? s.toLowerCase(locale) : null;
    }

    public static String uppercase(String s, Locale locale) {
        return s != null ? s.toUpperCase(locale) : null;
    }
}

