/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.app;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Named;
import org.dbrain.binder.app.App;
import org.dbrain.binder.app.Binder;
import org.dbrain.binder.app.ServiceConfigurator;
import org.dbrain.binder.system.util.AnnotationBuilder;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.FactoryDescriptors;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.ActiveDescriptorBuilder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;

public class BindingBuilderImpl<T>
implements ServiceConfigurator<T> {
    private ServiceConfigurator.ServiceProvider<T> provider;
    private ServiceConfigurator.ServiceDisposer<T> disposer;
    private final Set<Type> services = new HashSet<Type>();
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Class<? extends Annotation> scope;
    private boolean useProxy = false;

    public BindingBuilderImpl(App app, Binder.BindingContext cc, DynamicConfiguration dc, Class<T> serviceProviderClass) {
        Objects.requireNonNull(app);
        Objects.requireNonNull(cc);
        Objects.requireNonNull(dc);
        Objects.requireNonNull(serviceProviderClass);
        cc.onBind(binder -> {
            try {
                ActiveDescriptorBuilder serviceDescriptor;
                AbstractActiveDescriptor factoryDescriptor;
                ServiceLocator sl = app.getInstance(ServiceLocator.class);
                StandardFactory<T> factory = null;
                if (this.provider != null || this.disposer != null) {
                    ServiceConfigurator.ServiceProvider<T> finalProvider = this.provider;
                    ServiceConfigurator.ServiceDisposer<T> finalDisposer = this.disposer;
                    if (finalProvider == null) {
                        finalProvider = new StandardProvider(app, serviceProviderClass);
                    }
                    if (finalDisposer == null) {
                        finalDisposer = new StandardDisposer(app, serviceProviderClass);
                    }
                    factory = new StandardFactory<T>(finalProvider, finalDisposer);
                }
                if (factory != null) {
                    factoryDescriptor = BuilderHelper.createConstantDescriptor(factory);
                    factoryDescriptor.addContractType(Factory.class);
                    serviceDescriptor = BuilderHelper.activeLink(factory.getClass());
                } else {
                    factoryDescriptor = null;
                    serviceDescriptor = BuilderHelper.activeLink((Class)serviceProviderClass);
                }
                ArrayList<Type> finalServices = new ArrayList<Type>(this.services);
                if (finalServices.size() == 0) {
                    finalServices.add(serviceProviderClass);
                }
                for (Type service : finalServices) {
                    serviceDescriptor.to(service);
                    if (factoryDescriptor == null) continue;
                    factoryDescriptor.addContractType((Type)new ParameterizedTypeImpl(Factory.class, new Type[]{service}));
                }
                for (Annotation a : this.qualifiers) {
                    serviceDescriptor.qualifiedBy(a);
                    if (factoryDescriptor == null) continue;
                    factoryDescriptor.addQualifierAnnotation(a);
                }
                if (this.scope != null) {
                    serviceDescriptor.in(this.scope);
                } else {
                    serviceDescriptor.in(PerLookup.class);
                }
                if (this.useProxy) {
                    serviceDescriptor.proxy();
                }
                if (factoryDescriptor == null) {
                    dc.bind((Descriptor)sl.reifyDescriptor((Descriptor)serviceDescriptor.build()));
                } else {
                    dc.bind((FactoryDescriptors)new FactoryDescriptorsImpl((Descriptor)factoryDescriptor, (Descriptor)serviceDescriptor.buildProvideMethod()));
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MultiException((Throwable)e);
            }
        });
    }

    @Override
    public ServiceConfigurator<T> providedBy(T instance) {
        return this.providedBy(() -> instance);
    }

    @Override
    public ServiceConfigurator<T> providedBy(ServiceConfigurator.ServiceProvider<T> provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public ServiceConfigurator<T> disposedBy(ServiceConfigurator.ServiceDisposer<T> disposer) {
        this.disposer = disposer;
        return this;
    }

    @Override
    public ServiceConfigurator<T> to(Type type) {
        this.services.add(type);
        return this;
    }

    @Override
    public ServiceConfigurator<T> qualifiedBy(Annotation quality) {
        this.qualifiers.add(quality);
        return this;
    }

    @Override
    public ServiceConfigurator<T> qualifiedBy(Class<? extends Annotation> quality) {
        return this.qualifiedBy(AnnotationBuilder.of(quality));
    }

    @Override
    public ServiceConfigurator<T> qualifiedBy(Iterable<Annotation> qualities) {
        for (Annotation quality : qualities) {
            this.qualifiedBy(quality);
        }
        return this;
    }

    @Override
    public ServiceConfigurator<T> named(String name) {
        return this.qualifiedBy((Annotation)AnnotationBuilder.from(Named.class).value(name).build());
    }

    @Override
    public ServiceConfigurator<T> in(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public ServiceConfigurator<T> useProxy() {
        this.useProxy = true;
        return this;
    }

    private static class FactoryDescriptorsImpl
    implements FactoryDescriptors {
        private final Descriptor serviceDescriptor;
        private final Descriptor factoryDescriptor;

        public FactoryDescriptorsImpl(Descriptor serviceDescriptor, Descriptor factoryDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            this.factoryDescriptor = factoryDescriptor;
        }

        public Descriptor getFactoryAsAService() {
            return this.serviceDescriptor;
        }

        public Descriptor getFactoryAsAFactory() {
            return this.factoryDescriptor;
        }

        public String toString() {
            return "FactoryDescriptorsImpl(\n" + this.serviceDescriptor + ",\n" + this.factoryDescriptor + ",\n\t" + System.identityHashCode(this) + ")";
        }
    }

    private static class StandardFactory<T>
    implements Factory<T> {
        private ServiceConfigurator.ServiceProvider<T> provider;
        private ServiceConfigurator.ServiceDisposer<T> disposer;

        public StandardFactory(ServiceConfigurator.ServiceProvider<T> provider, ServiceConfigurator.ServiceDisposer<T> disposer) {
            this.provider = provider;
            this.disposer = disposer;
        }

        public T provide() {
            try {
                return this.provider.get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MultiException((Throwable)e);
            }
        }

        public void dispose(T instance) {
            try {
                this.disposer.dispose(instance);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MultiException((Throwable)e);
            }
        }
    }

    private static class StandardDisposer<T>
    implements ServiceConfigurator.ServiceDisposer<T> {
        private final App app;
        private final Class<T> implClass;

        public StandardDisposer(App app, Class<T> implClass) {
            this.app = app;
            this.implClass = implClass;
        }

        @Override
        public void dispose(T t) {
            if (t != null) {
                ClassAnalyzer analyzer = this.app.getInstance(ClassAnalyzer.class, "BINDER_ANALYZER_NAME");
                Method disposeMethod = analyzer.getPreDestroyMethod(this.implClass);
                try {
                    if (disposeMethod != null) {
                        disposeMethod.invoke(t, new Object[0]);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MultiException((Throwable)e);
                }
            }
        }
    }

    private static class StandardProvider<T>
    implements ServiceConfigurator.ServiceProvider<T> {
        private final ServiceLocator serviceLocator;
        private final Class<T> implClass;

        public StandardProvider(App app, Class<T> implClass) {
            this.serviceLocator = app.getInstance(ServiceLocator.class);
            this.implClass = implClass;
        }

        @Override
        public T get() {
            return (T)this.serviceLocator.create(this.implClass);
        }
    }
}

