/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.jetty;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionListener;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.dbrain.binder.directory.ServiceDirectory;
import org.dbrain.binder.directory.ServiceKey;
import org.dbrain.binder.http.conf.CredentialsConf;
import org.dbrain.binder.http.conf.FormLocationConf;
import org.dbrain.binder.http.conf.ServletAppSecurityConf;
import org.dbrain.binder.http.conf.ServletConf;
import org.dbrain.binder.http.conf.ServletContextConf;
import org.dbrain.binder.http.conf.ServletFilterConf;
import org.dbrain.binder.http.conf.WebSocketConfiguredServerConf;
import org.dbrain.binder.http.conf.WebSocketServerConf;
import org.dbrain.binder.http.conf.WebSocketServiceServerConf;
import org.dbrain.binder.system.app.SystemConfiguration;
import org.dbrain.binder.system.jetty.websocket.JsrScopedSessionFactory;
import org.dbrain.binder.system.jetty.websocket.WebSocketInjectorConfigurator;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

public class JettyServerBuilder {
    private final ServiceDirectory locator;

    public JettyServerBuilder(ServiceDirectory locator) {
        this.locator = locator;
    }

    public void configureFilter(final ServletContextHandler result, ServletFilterConf def) {
        def.accept(new ServletFilterConf.Visitor(){

            @Override
            public void visit(ServletFilterConf.ServletFilterInstanceDef servletDef) {
                result.addFilter(new FilterHolder(servletDef.getInstance()), servletDef.getPathSpec(), EnumSet.of(DispatcherType.REQUEST));
            }

            @Override
            public void visit(ServletFilterConf.ServletFilterClassDef servletDef) {
                Filter instance = JettyServerBuilder.this.locator.getOrCreateInstance(servletDef.getFilterClass());
                result.addFilter(new FilterHolder(instance), servletDef.getPathSpec(), EnumSet.of(DispatcherType.REQUEST));
            }
        });
    }

    public void configureServlet(final ServletContextHandler result, ServletConf def) {
        def.accept(new ServletConf.Visitor(){

            @Override
            public void visit(ServletConf.InstanceServletDef servletDef) {
                ServletHolder servletHolder = new ServletHolder(servletDef.getInstance());
                result.addServlet(servletHolder, servletDef.getPathSpec());
            }
        });
    }

    public FormAuthenticator createFormAuthenticator(FormLocationConf def) {
        return new FormAuthenticator(def.getUrl(), def.getErrorURL(), false);
    }

    public HashLoginService createHashLoginService(CredentialsConf def) {
        return new HashLoginService(def.getRealm(), def.getFile());
    }

    public ConstraintSecurityHandler createConstraintSecurityHandler(ServletAppSecurityConf def) {
        ConstraintMapping cm = new ConstraintMapping();
        cm.setPathSpec(def.getPathSpec());
        cm.setConstraint(ConstraintSecurityHandler.createConstraint((String)"FORM", (boolean)true, (String[])new String[]{def.getCredentialsDef().getSingleRole()}, (int)0));
        ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
        sh.setRealmName(def.getCredentialsDef().getRealm());
        sh.setAuthenticator((Authenticator)this.createFormAuthenticator(def.getFormLocationDef()));
        sh.setLoginService((LoginService)this.createHashLoginService(def.getCredentialsDef()));
        sh.setConstraintMappings(Arrays.asList(cm));
        return sh;
    }

    public void configureWebSocket(final org.eclipse.jetty.websocket.jsr356.server.ServerContainer serverContainer, WebSocketServerConf webSocketDef) throws Exception {
        webSocketDef.accept(new WebSocketServerConf.Visitor(){

            private void configureServerEndpointConfig(ServerEndpointConfig config, ServiceKey<?> serviceKey) throws Exception {
                config = ServerEndpointConfig.Builder.create((Class)config.getEndpointClass(), (String)config.getPath()).decoders(config.getDecoders()).encoders(config.getEncoders()).extensions(config.getExtensions()).subprotocols(config.getSubprotocols()).configurator((ServerEndpointConfig.Configurator)new WebSocketInjectorConfigurator(JettyServerBuilder.this.locator, config.getConfigurator(), serviceKey)).build();
                serverContainer.addEndpoint(config);
            }

            @Override
            public void visit(WebSocketServiceServerConf endpointClassWebSocketConf) throws Exception {
                ServerEndpointConfig config = serverContainer.getServerEndpointMetadata(endpointClassWebSocketConf.getEndpointService().getServiceClass(), null).getConfig();
                this.configureServerEndpointConfig(config, endpointClassWebSocketConf.getEndpointService());
            }

            @Override
            public void visit(WebSocketConfiguredServerConf websocketServerEndpointConfig) throws Exception {
                this.configureServerEndpointConfig(websocketServerEndpointConfig.getConfig(), ServiceKey.of(websocketServerEndpointConfig.getConfig().getEndpointClass()));
            }
        });
    }

    public org.eclipse.jetty.websocket.jsr356.server.ServerContainer configureContext(ServletContextHandler context) throws ServletException {
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext((ServletContextHandler)context);
        JsrScopedSessionFactory scopedSessionFactory = this.locator.getOrCreateInstance(JsrScopedSessionFactory.class);
        filter.getFactory().addSessionFactory((SessionFactory)scopedSessionFactory);
        org.eclipse.jetty.websocket.jsr356.server.ServerContainer jettyContainer = new org.eclipse.jetty.websocket.jsr356.server.ServerContainer((MappedWebSocketCreator)filter, filter.getFactory(), (Executor)context.getServer().getThreadPool());
        scopedSessionFactory.configure((ClientContainer)jettyContainer, new SessionListener[]{jettyContainer});
        context.addBean((Object)jettyContainer);
        context.setAttribute(ServerContainer.class.getName(), (Object)jettyContainer);
        return jettyContainer;
    }

    public Handler configureServletContextHandler(Server server, ServletContextConf config) {
        ServletContextHandler servletContextHandler = new ServletContextHandler(config.getSecurity() != null ? 1 : 0);
        servletContextHandler.setContextPath(config.getContextPath());
        servletContextHandler.setServer(server);
        if (config.getWebSockets().size() > 0) {
            try {
                org.eclipse.jetty.websocket.jsr356.server.ServerContainer wscontainer = this.configureContext(servletContextHandler);
                for (WebSocketServerConf wsd : config.getWebSockets()) {
                    this.configureWebSocket(wscontainer, wsd);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (config.getSecurity() != null) {
            servletContextHandler.setInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName", "none");
            servletContextHandler.setSecurityHandler((SecurityHandler)this.createConstraintSecurityHandler(config.getSecurity()));
        }
        SessionHandler sessionHandler = new SessionHandler();
        servletContextHandler.setSessionHandler(sessionHandler);
        this.locator.listServices(ServletContextListener.class, SystemConfiguration.class).forEach(arg_0 -> ((ServletContextHandler)servletContextHandler).addEventListener(arg_0));
        if (sessionHandler != null) {
            this.locator.listServices(HttpSessionListener.class, SystemConfiguration.class).forEach(arg_0 -> ((SessionHandler)sessionHandler).addEventListener(arg_0));
        }
        for (ServletFilterConf filterDef : this.locator.listServices(ServletFilterConf.class, SystemConfiguration.class)) {
            this.configureFilter(servletContextHandler, filterDef);
        }
        for (ServletFilterConf filterDef : config.getFilters()) {
            this.configureFilter(servletContextHandler, filterDef);
        }
        for (ServletConf servletDef : config.getServlets()) {
            this.configureServlet(servletContextHandler, servletDef);
        }
        return servletContextHandler;
    }

    public Handler configureServletContextsHandler(Server server, List<ServletContextConf> defs) {
        if (defs == null || defs.size() == 0) {
            return null;
        }
        if (defs.size() == 1) {
            return this.configureServletContextHandler(server, defs.get(0));
        }
        HandlerList result = new HandlerList();
        result.setServer(server);
        for (ServletContextConf def : defs) {
            result.addHandler(this.configureServletContextHandler(server, def));
        }
        return result;
    }
}

