/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.jetty.websocket;

import java.net.URI;
import javax.inject.Provider;
import org.dbrain.binder.system.lifecycle.ContextRegistry;
import org.dbrain.binder.system.scope.RequestScopeContext;
import org.dbrain.binder.system.scope.SessionScopeContext;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.JsrSession;

public class JsrScopedSession
extends JsrSession {
    private final RequestScopeContext requestScopeContext;
    private final SessionScopeContext sessionScopeContext;
    private final ContextRegistry scopeRegistry = new ContextRegistry();

    public JsrScopedSession(RequestScopeContext requestScopeContext, SessionScopeContext sessionScopeContext, LogicalConnection connection, ClientContainer container, String id, URI requestURI, EventDriver websocket, SessionListener ... sessionListeners) {
        super(requestURI, websocket, connection, container, id, sessionListeners);
        this.requestScopeContext = requestScopeContext;
        this.sessionScopeContext = sessionScopeContext;
    }

    public void notifyClose(int statusCode, String reason) {
        super.notifyClose(statusCode, reason);
        this.scopeRegistry.close();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void destroy() {
        super.destroy();
    }

    public void incomingFrame(Frame frame) {
        this.requestScopeContext.enter();
        this.sessionScopeContext.enter((Provider<ContextRegistry>)((Provider)() -> this.scopeRegistry));
        try {
            super.incomingFrame(frame);
        }
        finally {
            this.requestScopeContext.leave();
            this.sessionScopeContext.leave();
        }
    }
}

