/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.http;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.dbrain.binder.app.App;
import org.dbrain.binder.app.Binder;
import org.dbrain.binder.http.AbstractHttpServerModule;
import org.dbrain.binder.http.conf.ConnectorConf;
import org.dbrain.binder.http.conf.HttpServerConf;
import org.dbrain.binder.system.jetty.JettyConnectors;
import org.dbrain.binder.system.jetty.JettyServerBuilder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class JettyServerModule
extends AbstractHttpServerModule<JettyServerModule> {
    private final App app;

    @Inject
    public JettyServerModule(App app) {
        this.app = app;
    }

    protected Server build(HttpServerConf def) {
        Server server = new Server();
        for (ConnectorConf connector : def.getEndPoints()) {
            JettyConnectors.configureConnector(server, connector);
        }
        Handler handler = new JettyServerBuilder(this.app).configureServletContextsHandler(server, def.getServletContexts());
        if (handler != null) {
            server.setHandler(handler);
        }
        return server;
    }

    @Override
    public void configure(Binder binder) throws Exception {
        binder.bind(Server.class).toInstance((Class<Server>)this.build(this.getHttpServerConfig())).disposedBy(server -> server.stop()).qualifiedBy(this.buildQualifiers()).to((Type)((Object)Server.class)).in(Singleton.class);
    }
}

