/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.app;

import java.util.List;
import javax.inject.Inject;
import org.dbrain.binder.app.App;
import org.dbrain.binder.app.Binder;
import org.dbrain.binder.app.Module;
import org.dbrain.binder.app.ServiceConfigurator;
import org.dbrain.binder.system.app.BindingBuilderImpl;
import org.dbrain.binder.system.app.BindingStack;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;

public class SimpleBinder
implements Binder {
    private final App app;
    private final BindingStack bindingStack;
    private DynamicConfiguration dc;

    @Inject
    public SimpleBinder(App app, BindingStack bindingStack) {
        this.app = app;
        this.bindingStack = bindingStack;
        this.dc = app.getInstance(DynamicConfigurationService.class).createDynamicConfiguration();
    }

    @Override
    public <T> ServiceConfigurator<T> bind(Class<T> implementationClass) {
        return new BindingBuilderImpl<T>(this.app, this.bindingStack, this.dc, implementationClass);
    }

    @Override
    public <T> ServiceConfigurator<T> bind(T implementation) {
        return this.bind((T)implementation.getClass()).toInstance((Class<?>)implementation);
    }

    @Override
    public <T extends Module> T bindModule(Class<T> componentClass) {
        Module module = (Module)this.app.getOrCreateInstance(componentClass);
        this.bindingStack.pushModule(module::configure);
        return (T)module;
    }

    public BindingStack getBindingContext() {
        return this.bindingStack;
    }

    public void commit() throws Exception {
        List<Module> binders = this.bindingStack.empty();
        while (binders != null) {
            for (Module b : binders) {
                b.configure(this);
            }
            binders = this.bindingStack.empty();
        }
        this.dc.commit();
    }
}

