/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.http.server.utils;

import java.net.URI;

public class ResourceSandbox {
    private String prefix = null;
    private final URI sandbox = URI.create("http://sandbox.com/a/");
    private final URI rootUri;

    public ResourceSandbox(URI rootUri) {
        if (rootUri == null || !rootUri.isAbsolute()) {
            throw new IllegalArgumentException(rootUri.toString());
        }
        if (rootUri.isOpaque()) {
            if (rootUri.getScheme().equalsIgnoreCase("jar")) {
                rootUri = URI.create(rootUri.getRawSchemeSpecificPart());
                this.prefix = "jar";
            } else {
                throw new IllegalArgumentException("Unsupported opaque URI: " + rootUri);
            }
        }
        this.rootUri = rootUri;
    }

    public URI getResource(URI trailingUri) {
        if (trailingUri == null || trailingUri.isAbsolute() || trailingUri.isOpaque()) {
            throw new IllegalArgumentException(trailingUri.toString());
        }
        if (!this.sandbox.resolve(trailingUri).normalize().getPath().startsWith(this.sandbox.getPath())) {
            throw new IllegalArgumentException(trailingUri.toString());
        }
        URI result = URI.create(this.rootUri.toString()).resolve(trailingUri).normalize();
        return this.prefix != null ? URI.create(this.prefix + ":" + result.toString()) : result;
    }

    public URI getResource(String trailingUri) {
        return this.getResource(URI.create(trailingUri));
    }
}

