/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.jetty;

import org.dbrain.binder.http.conf.ConnectorConf;
import org.dbrain.binder.http.conf.HttpConnectorConf;
import org.dbrain.binder.http.conf.HttpsConnectorConf;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyConnectors {
    private static HttpConfiguration getStandardConfiguration(HttpConnectorConf config) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        httpConfiguration.setSendDateHeader(false);
        return httpConfiguration;
    }

    private static void configureCommonFields(ServerConnector connector, HttpConnectorConf config) {
        if (config.getHost() != null) {
            connector.setHost(config.getHost());
        }
    }

    public static void configureConnector(Server server, HttpConnectorConf config) {
        HttpConfiguration httpConfiguration = JettyConnectors.getStandardConfiguration(config);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        JettyConnectors.configureCommonFields(connector, config);
        connector.setPort(config.getPort().intValue());
        server.addConnector((Connector)connector);
    }

    public static void configureConnector(Server server, HttpsConnectorConf config) {
        FileResource keyStoreResource = new FileResource(config.getKeyStore());
        HttpConfiguration httpConfiguration = JettyConnectors.getStandardConfiguration(config);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStoreResource((Resource)keyStoreResource);
        sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(config.getKeyManagerPassord());
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
        JettyConnectors.configureCommonFields(sslConnector, config);
        sslConnector.setPort(config.getPort().intValue());
        server.addConnector((Connector)sslConnector);
    }

    public static void configureConnector(Server server, ConnectorConf connector) {
        if (connector instanceof HttpsConnectorConf) {
            JettyConnectors.configureConnector(server, (HttpsConnectorConf)connector);
        } else if (connector instanceof HttpConnectorConf) {
            JettyConnectors.configureConnector(server, (HttpConnectorConf)connector);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

