/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.lifecycle;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.MultiException;

@Singleton
@Named(value="BINDER_ANALYZER_NAME")
public class BaseClassAnalyzer
implements ClassAnalyzer {
    public static final String BINDER_ANALYZER_NAME = "BINDER_ANALYZER_NAME";
    private ClassAnalyzer defaultAnalyzer;

    @Inject
    public BaseClassAnalyzer(@Named(value="default") ClassAnalyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public <T> Constructor<T> getConstructor(Class<T> clazz) throws MultiException, NoSuchMethodException {
        return this.defaultAnalyzer.getConstructor(clazz);
    }

    public <T> Set<Method> getInitializerMethods(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getInitializerMethods(clazz);
    }

    public <T> Set<Field> getFields(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getFields(clazz);
    }

    public <T> Method getPostConstructMethod(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getPostConstructMethod(clazz);
    }

    public <T> Method getPreDestroyMethod(Class<T> clazz) throws MultiException {
        Method m = this.defaultAnalyzer.getPreDestroyMethod(clazz);
        if (m == null && AutoCloseable.class.isAssignableFrom(clazz)) {
            try {
                m = clazz.getDeclaredMethod("close", new Class[0]);
            }
            catch (Exception e) {
                throw new MultiException((Throwable)e);
            }
        }
        return m;
    }
}

