/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.lifecycle;

import java.util.Objects;
import java.util.Stack;
import javax.inject.Provider;

public class ThreadLocalProvider<T>
implements Provider<T> {
    private ThreadLocal<Stack<Provider<T>>> contextStack = new ThreadLocal();

    public void enter(Provider<T> context) {
        Objects.requireNonNull(context);
        Stack<Object> stack = this.contextStack.get();
        if (stack == null) {
            stack = new Stack();
            this.contextStack.set(stack);
        }
        stack.push(context);
    }

    public Provider<T> leave() {
        Provider<T> result;
        Stack<Provider<T>> stack = this.contextStack.get();
        if (stack != null) {
            result = stack.pop();
            if (stack.size() == 0) {
                this.contextStack.set(null);
            }
        } else {
            throw new IllegalStateException("The context stack is empty.");
        }
        return result;
    }

    public T get() {
        Stack<Provider<T>> stack = this.contextStack.get();
        return (T)(stack != null ? stack.peek().get() : null);
    }

    public int size() {
        Stack<Provider<T>> stack = this.contextStack.get();
        return stack != null ? stack.size() : 0;
    }
}

