/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.txs.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbrain.binder.system.txs.TransactionMember;
import org.dbrain.binder.txs.TransactionException;

public class JdbcConnectionWrapper
implements TransactionMember.Wrapper<Connection> {
    @Override
    public Class<Connection> forClass() {
        return Connection.class;
    }

    @Override
    public TransactionMember wrap(Connection instance) {
        return new ConnectionToMemberAdapter(instance);
    }

    public static class ConnectionToMemberAdapter
    implements TransactionMember {
        private final Connection connection;

        public ConnectionToMemberAdapter(Connection connection) {
            this.connection = connection;
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void flush() throws TransactionException {
        }

        @Override
        public void commit() throws TransactionException {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new TransactionException(e);
            }
        }

        @Override
        public void rollback() throws TransactionException {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw new TransactionException(e);
            }
        }
    }
}

